/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatGeneratorRecipe
implements Recipe<SimpleContainer> {
    private final Fluid[] input;
    private final int energyProduction;

    public HeatGeneratorRecipe(Fluid[] input, int energyProduction) {
        this.input = input;
        this.energyProduction = energyProduction;
    }

    public Fluid[] getInput() {
        return this.input;
    }

    public int getEnergyProduction() {
        return this.energyProduction;
    }

    public boolean matches(SimpleContainer container, Level level) {
        return false;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.HEAT_GENERATOR_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<HeatGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "heat_generator");
        private final Codec<HeatGeneratorRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(new ArrayCodec(ForgeRegistries.FLUIDS.getCodec(), Fluid[]::new), (Codec)ForgeRegistries.FLUIDS.getCodec()).fieldOf("input").forGetter(recipe -> Either.left((Object)recipe.input)), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energyProduction)).apply((Applicative)instance, (input, energy) -> (HeatGeneratorRecipe)input.map(f -> new HeatGeneratorRecipe((Fluid[])f, (int)energy), f -> new HeatGeneratorRecipe(new Fluid[]{f}, (int)energy))));

        private Serializer() {
        }

        public Codec<HeatGeneratorRecipe> m_292673_() {
            return this.CODEC;
        }

        public HeatGeneratorRecipe fromNetwork(FriendlyByteBuf buffer) {
            int fluidCount = buffer.readInt();
            Fluid[] input = new Fluid[fluidCount];
            for (int i = 0; i < fluidCount; ++i) {
                input[i] = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
            }
            int energyProduction = buffer.readInt();
            return new HeatGeneratorRecipe(input, energyProduction);
        }

        public void toNetwork(FriendlyByteBuf buffer, HeatGeneratorRecipe recipe) {
            buffer.writeInt(recipe.getInput().length);
            for (Fluid fluid : recipe.input) {
                ResourceLocation fluidId = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                if (fluidId == null) {
                    throw new IllegalArgumentException("Unregistered fluid '" + fluid + "'");
                }
                buffer.m_130085_(fluidId);
            }
            buffer.writeInt(recipe.energyProduction);
        }
    }

    public static final class Type
    implements RecipeType<HeatGeneratorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "heat_generator";

        private Type() {
        }
    }
}

