/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MetalPressRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final ItemStack pressMold;
    private final Ingredient input;
    private final int inputCount;

    public MetalPressRecipe(ItemStack output, ItemStack pressMold, Ingredient input, int inputCount) {
        this.output = output;
        this.pressMold = pressMold;
        this.input = input;
        this.inputCount = inputCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getPressMold() {
        return this.pressMold;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0)) && container.m_8020_(0).m_41613_() >= this.inputCount && ItemStack.m_150942_((ItemStack)this.pressMold, (ItemStack)container.m_8020_(1));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.METAL_PRESS_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<MetalPressRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "metal_press");
        private final Codec<MetalPressRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)CodecFix.ITEM_STACK_CODEC.fieldOf("pressMold").forGetter(recipe -> recipe.pressMold), (App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.f_144629_.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount)).apply((Applicative)instance, MetalPressRecipe::new));

        private Serializer() {
        }

        public Codec<MetalPressRecipe> m_292673_() {
            return this.CODEC;
        }

        public MetalPressRecipe fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputCount = buffer.readInt();
            ItemStack pressMold = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new MetalPressRecipe(output, pressMold, input, inputCount);
        }

        public void toNetwork(FriendlyByteBuf buffer, MetalPressRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.inputCount);
            buffer.writeItemStack(recipe.pressMold, false);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<MetalPressRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "metal_press";

        private Type() {
        }
    }
}

