/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlantGrowthChamberFertilizerRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient input;
    private final double speedMultiplier;
    private final double energyConsumptionMultiplier;

    public PlantGrowthChamberFertilizerRecipe(Ingredient input, double speedMultiplier, double energyConsumptionMultiplier) {
        this.input = input;
        this.speedMultiplier = speedMultiplier;
        this.energyConsumptionMultiplier = energyConsumptionMultiplier;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public double getEnergyConsumptionMultiplier() {
        return this.energyConsumptionMultiplier;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(1));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PLANT_GROWTH_CHAMBER_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PlantGrowthChamberFertilizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "plant_growth_chamber_fertilizer");
        private final Codec<PlantGrowthChamberFertilizerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)Codec.DOUBLE.fieldOf("speedMultiplier").forGetter(recipe -> recipe.speedMultiplier), (App)Codec.DOUBLE.fieldOf("energyConsumptionMultiplier").forGetter(recipe -> recipe.energyConsumptionMultiplier)).apply((Applicative)instance, PlantGrowthChamberFertilizerRecipe::new));

        private Serializer() {
        }

        public Codec<PlantGrowthChamberFertilizerRecipe> m_292673_() {
            return this.CODEC;
        }

        public PlantGrowthChamberFertilizerRecipe fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            double speedMultiplier = buffer.readDouble();
            double energyConsumptionMultiplier = buffer.readDouble();
            return new PlantGrowthChamberFertilizerRecipe(input, speedMultiplier, energyConsumptionMultiplier);
        }

        public void toNetwork(FriendlyByteBuf buffer, PlantGrowthChamberFertilizerRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeDouble(recipe.speedMultiplier);
            buffer.writeDouble(recipe.energyConsumptionMultiplier);
        }
    }

    public static final class Type
    implements RecipeType<PlantGrowthChamberFertilizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber_fertilizer";

        private Type() {
        }
    }
}

