/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PressMoldMakerRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final int clayCount;

    public PressMoldMakerRecipe(ItemStack output, int clayCount) {
        this.output = output;
        this.clayCount = clayCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getClayCount() {
        return this.clayCount;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ItemStack item = container.m_8020_(0);
        return item.m_150930_(Items.f_42461_) && item.m_41613_() >= this.clayCount;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PRESS_MOLD_MAKER_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PressMoldMakerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "press_mold_maker");
        private final Codec<PressMoldMakerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)ExtraCodecs.f_144629_.fieldOf("clayCount").forGetter(recipe -> recipe.clayCount)).apply((Applicative)instance, PressMoldMakerRecipe::new));

        private Serializer() {
        }

        public Codec<PressMoldMakerRecipe> m_292673_() {
            return this.CODEC;
        }

        public PressMoldMakerRecipe fromNetwork(FriendlyByteBuf buffer) {
            int clayCount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            return new PressMoldMakerRecipe(output, clayCount);
        }

        public void toNetwork(FriendlyByteBuf buffer, PressMoldMakerRecipe recipe) {
            buffer.writeInt(recipe.clayCount);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<PressMoldMakerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "press_mold_maker";

        private Type() {
        }
    }
}

