/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PulverizerRecipe
implements Recipe<SimpleContainer> {
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final Ingredient input;

    public PulverizerRecipe(OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, Ingredient input) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.output.m_255036_(this.output.percentages.length), this.secondaryOutput.output.m_255036_(this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : output.percentages) {
                if (!(randomSource.m_188500_() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.m_255036_(count);
        }
        return generatedOutputs;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PULVERIZER_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(ItemStack output, double[] percentages) {
        private static Codec<double[]> createDoubleArrayCodec(final boolean atLeastOnePercentageValue) {
            return new Codec<double[]>(){
                private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

                public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
                    return DOUBLE_LIST_CODEC.decode(ops, input).flatMap(res -> {
                        boolean errorFlag = atLeastOnePercentageValue && ((List)res.getFirst()).stream().noneMatch(d -> (int)d.doubleValue() >= 1);
                        Pair newRes = Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond());
                        if (errorFlag) {
                            return DataResult.error(() -> "The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)", (Object)newRes);
                        }
                        return DataResult.success((Object)newRes);
                    });
                }

                public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
                    return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
                }
            };
        }

        public static Codec<OutputItemStackWithPercentages> createCodec(boolean atLeastOnePercentageValue) {
            return RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(output -> output.output), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).fieldOf("percentages").forGetter(output -> output.percentages)).apply((Applicative)instance, OutputItemStackWithPercentages::new));
        }
    }

    public static final class Serializer
    implements RecipeSerializer<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "pulverizer");
        private final Codec<PulverizerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OutputItemStackWithPercentages.createCodec(true).fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.createCodec(false).optionalFieldOf("secondaryOutput", (Object)new OutputItemStackWithPercentages(ItemStack.f_41583_, new double[0])).forGetter(recipe -> recipe.secondaryOutput), (App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, PulverizerRecipe::new));

        private Serializer() {
        }

        public Codec<PulverizerRecipe> m_292673_() {
            return this.CODEC;
        }

        public PulverizerRecipe fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                ItemStack output = buffer.m_130267_();
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages);
            }
            return new PulverizerRecipe(outputs[0], outputs[1], input);
        }

        public void toNetwork(FriendlyByteBuf buffer, PulverizerRecipe recipe) {
            recipe.input.m_43923_(buffer);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                buffer.writeItemStack(output.output, false);
                buffer.writeInt(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.writeDouble(percentage);
                }
            }
        }
    }

    public static final class Type
    implements RecipeType<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

