/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StoneSolidifierRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final int waterAmount;
    private final int lavaAmount;

    public StoneSolidifierRecipe(ItemStack output, int waterAmount, int lavaAmount) {
        this.output = output;
        this.waterAmount = waterAmount;
        this.lavaAmount = lavaAmount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getWaterAmount() {
        return this.waterAmount;
    }

    public int getLavaAmount() {
        return this.lavaAmount;
    }

    public boolean matches(SimpleContainer container, Level level) {
        return false;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.STONE_SOLIDIFIER.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<StoneSolidifierRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "stone_solidifier");
        private final Codec<StoneSolidifierRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)ExtraCodecs.f_144629_.fieldOf("waterAmount").forGetter(recipe -> recipe.waterAmount), (App)ExtraCodecs.f_144629_.fieldOf("lavaAmount").forGetter(recipe -> recipe.lavaAmount)).apply((Applicative)instance, StoneSolidifierRecipe::new));

        private Serializer() {
        }

        public Codec<StoneSolidifierRecipe> m_292673_() {
            return this.CODEC;
        }

        public StoneSolidifierRecipe fromNetwork(FriendlyByteBuf buffer) {
            int waterAmount = buffer.readInt();
            int lavaAmount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            return new StoneSolidifierRecipe(output, waterAmount, lavaAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, StoneSolidifierRecipe recipe) {
            buffer.writeInt(recipe.waterAmount);
            buffer.writeInt(recipe.lavaAmount);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<StoneSolidifierRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "stone_solidifier";

        private Type() {
        }
    }
}

