/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.AdvancedAutoCrafterBlockEntity;
import me.jddev0.ep.inventory.PatternResultSlot;
import me.jddev0.ep.inventory.PatternSlot;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.screen.EnergyStorageConsumerIndicatorBarMenu;
import me.jddev0.ep.screen.ModMenuTypes;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class AdvancedAutoCrafterMenu
extends AbstractContainerMenu
implements EnergyStorageConsumerIndicatorBarMenu {
    private final AdvancedAutoCrafterBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final Container[] patternSlots;
    private final Container[] patternResultSlots;

    public AdvancedAutoCrafterMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), new Container[]{new SimpleContainer(9), new SimpleContainer(9), new SimpleContainer(9)}, new Container[]{new SimpleContainer(1), new SimpleContainer(1), new SimpleContainer(1)}, (ContainerData)new SimpleContainerData(27));
    }

    public AdvancedAutoCrafterMenu(int id, Inventory inv, BlockEntity blockEntity, Container[] patternSlots, Container[] patternResultSlots, ContainerData data) {
        super((MenuType)ModMenuTypes.ADVANCED_AUTO_CRAFTER_MENU.get(), id);
        this.patternSlots = patternSlots;
        this.patternResultSlots = patternResultSlots;
        AdvancedAutoCrafterMenu.m_38886_((ContainerData)data, (int)27);
        this.blockEntity = (AdvancedAutoCrafterBlockEntity)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_((Slot)new SlotItemHandler(itemHandler, 9 * i + j, 8 + 18 * j, 75 + 18 * i));
                }
            }
        });
        for (int ri = 0; ri < 3; ++ri) {
            final int recipeIndex = ri;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.m_38897_(new PatternSlot(patternSlots[recipeIndex], j + i * 3, 30 + j * 18, 17 + i * 18, () -> true){

                        public boolean m_6659_() {
                            return AdvancedAutoCrafterMenu.this.getRecipeIndex() == recipeIndex;
                        }
                    });
                }
            }
            this.m_38897_(new PatternResultSlot(patternResultSlots[recipeIndex], 0, 124, 35, () -> true){

                public boolean m_6659_() {
                    return AdvancedAutoCrafterMenu.this.getRecipeIndex() == recipeIndex;
                }
            });
        }
        this.m_38884_(this.data);
    }

    public Container[] getPatternSlots() {
        return this.patternSlots;
    }

    @Override
    public int getEnergy() {
        return this.blockEntity.getEnergy();
    }

    @Override
    public int getCapacity() {
        return this.blockEntity.getCapacity();
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        int energyIndicatorBarValueSum = -1;
        for (int i = 12; i < 18; i += 2) {
            int value = ByteUtils.from2ByteChunks((short)this.data.m_6413_(i), (short)this.data.m_6413_(i + 1));
            if ((long)(energyIndicatorBarValueSum + value) != (long)energyIndicatorBarValueSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            if (value <= -1) continue;
            if (energyIndicatorBarValueSum == -1) {
                ++energyIndicatorBarValueSum;
            }
            energyIndicatorBarValueSum += value;
        }
        return energyIndicatorBarValueSum;
    }

    public boolean isCraftingActive() {
        int index = this.getRecipeIndex();
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(4 * index), (short)this.data.m_6413_(1 + 4 * index)) > 0;
    }

    public boolean isCrafting() {
        int index = this.getRecipeIndex();
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(4 * index), (short)this.data.m_6413_(1 + 4 * index)) > 0 && this.data.m_6413_(18 + index) == 1;
    }

    public int getScaledProgressArrowSize() {
        int index = this.getRecipeIndex();
        int progress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(4 * index), (short)this.data.m_6413_(1 + 4 * index));
        int maxProgress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(2 + 4 * index), (short)this.data.m_6413_(3 + 4 * index));
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public boolean isIgnoreNBT() {
        int index = this.getRecipeIndex();
        return this.data.m_6413_(21 + index) != 0;
    }

    public boolean isSecondaryExtractMode() {
        return this.data.m_6413_(24) != 0;
    }

    public int getRecipeIndex() {
        return this.data.m_6413_(25);
    }

    public RedstoneMode getRedstoneMode() {
        return RedstoneMode.fromIndex(this.data.m_6413_(26));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceItem = sourceSlot.m_7993_();
        ItemStack sourceItemCopy = sourceItem.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceItem, 41, 63, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 63) {
            if (!this.m_38903_(sourceItem, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (index < 93) {
                return ItemStack.f_41583_;
            }
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean m_6875_(Player player) {
        return AdvancedAutoCrafterMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.ADVANCED_AUTO_CRAFTER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 142 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 200));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

