/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.AssemblingMachineBlockEntity;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.screen.EnergyStorageConsumerIndicatorBarMenu;
import me.jddev0.ep.screen.ModMenuTypes;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class AssemblingMachineMenu
extends AbstractContainerMenu
implements EnergyStorageConsumerIndicatorBarMenu {
    private final AssemblingMachineBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public AssemblingMachineMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public AssemblingMachineMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.ASSEMBLING_MACHINE_MENU.get(), id);
        AssemblingMachineMenu.m_38886_((ContainerData)data, (int)8);
        this.blockEntity = (AssemblingMachineBlockEntity)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 0, 62, 19));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 1, 44, 37));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 2, 80, 37));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 3, 62, 55));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 4, 134, 37));
        });
        this.m_38884_(this.data);
    }

    @Override
    public int getEnergy() {
        return this.blockEntity.getEnergy();
    }

    @Override
    public int getCapacity() {
        return this.blockEntity.getCapacity();
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(4), (short)this.data.m_6413_(5));
    }

    public boolean isCraftingActive() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1)) > 0;
    }

    public boolean isCrafting() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1)) > 0 && this.data.m_6413_(6) == 1;
    }

    public int getScaledProgressArrowSize() {
        int progress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1));
        int maxProgress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(2), (short)this.data.m_6413_(3));
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public RedstoneMode getRedstoneMode() {
        return RedstoneMode.fromIndex(this.data.m_6413_(7));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceItem = sourceSlot.m_7993_();
        ItemStack sourceItemCopy = sourceItem.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceItem, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 41) {
            if (!this.m_38903_(sourceItem, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean m_6875_(Player player) {
        return AssemblingMachineMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.ASSEMBLING_MACHINE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 88 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 146));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

