/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankScreen
extends AbstractContainerScreen<FluidTankMenu> {
    private final ResourceLocation TEXTURE = new ResourceLocation("energizedpower", "textures/gui/container/generic_fluid.png");

    public FluidTankScreen(FluidTankMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    public FluidTankBlock.Tier getTier() {
        return ((FluidTankMenu)this.f_97732_).getTier();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderFluidMeterContent(guiGraphics, x, y);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
    }

    private void renderFluidMeterContent(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(x + 80), (float)(y + 17), 0.0f);
        this.renderFluidStack(guiGraphics);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(GuiGraphics guiGraphics) {
        FluidStack fluidStack = ((FluidTankMenu)this.f_97732_).getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        int capacity = ((FluidTankMenu)this.f_97732_).getTankCapacity();
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillFluidImageId = fluidTypeExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillFluidImageId);
        int fluidColorTint = fluidTypeExtensions.getTintColor(fluidStack);
        int fluidMeterPos = 52 - (fluidStack.getAmount() <= 0 || capacity == 0 ? 0 : Math.min(fluidStack.getAmount(), capacity - 1) * 52 / capacity + 1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        for (int yOffset = 52; yOffset > fluidMeterPos; yOffset -= 16) {
            int height = Math.min(yOffset - fluidMeterPos, 16);
            float u0 = stillFluidSprite.m_118409_();
            float u1 = stillFluidSprite.m_118410_();
            float v0 = stillFluidSprite.m_118411_();
            float v1 = stillFluidSprite.m_118412_();
            v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(mat, 0.0f, (float)yOffset, 0.0f).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(mat, 16.0f, (float)yOffset, 0.0f).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(mat, 16.0f, (float)(yOffset - height), 0.0f).m_7421_(u1, v0).m_5752_();
            bufferBuilder.m_252986_(mat, 0.0f, (float)(yOffset - height), 0.0f).m_7421_(u0, v0).m_5752_();
            tesselator.m_85914_();
        }
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + 80, y + 17, 176, 53, 16, 52);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.m_6774_(80, 17, 16, 52, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidTankMenu)this.f_97732_).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidTankMenu)this.f_97732_).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidTankMenu)this.f_97732_).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FluidTankMenu)this.f_97732_).getFluid().getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

