/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.exocraft.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import xxrexraptorxx.exocraft.main.Exocraft;
import xxrexraptorxx.exocraft.utils.mixins.LootTableAccessor;

@Mod.EventBusSubscriber(modid="exocraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootTableInjection {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Map<String, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation end_city_treasure = LootTableInjection.registerInject("end_city_treasure");
    public static final ResourceLocation ancient_city = LootTableInjection.registerInject("ancient_city");
    public static final ResourceLocation bastion_treasure = LootTableInjection.registerInject("bastion_treasure");
    private static int injected = 0;

    @NotNull
    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = LootTableInjection.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    @NotNull
    static ResourceLocation register(@NotNull String resourceName) {
        return LootTableInjection.register(new ResourceLocation("exocraft", resourceName));
    }

    @NotNull
    static ResourceLocation register(@NotNull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @SubscribeEvent
    public static void onChestLootLoad(@NotNull LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                ((LootTableAccessor)event.getTable()).getPools().add(LootTableInjection.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                Exocraft.LOGGER.error("Loottable {} is broken by some other mod. Cannot add EXO-Craft loot to it. " + name);
            }
        }
    }

    @NotNull
    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(entryName)).m_79707_(1);
        return LootPool.m_79043_().m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_();
    }

    public static int checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return Math.max(0, INJECTION_TABLES.size() - i);
    }
}

