/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.client.RepaintableBlockModel;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class RepaintableBlockTile
extends ForgeTile {
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresWaterBucket;
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresDye;
    protected BlockState targetBlock = Blocks.f_50016_.m_49966_();

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && !event.getEntity().m_6144_() && ForgeEntity.hasBrushInHand((LivingEntity)event.getEntity(), InteractionHand.OFF_HAND) && event.getLevel().m_7702_(event.getPos()) instanceof RepaintableBlockTile) {
            boolean placeBlock;
            Block block = Block.m_49814_((Item)event.getEntity().m_21205_().m_41720_());
            boolean bl = placeBlock = block instanceof ISmokeContainer || block instanceof IPole;
            if (!placeBlock) {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    public RepaintableBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(RepaintableBlockModel.BLOCK_STATE, (Object)this.targetBlock).build();
    }

    public void setTargetBlock(BlockState newState) {
        if (this.targetBlock != newState) {
            this.targetBlock = newState;
            this.syncWithClients();
        }
    }

    public BlockState getTargetBlock() {
        return this.targetBlock;
    }

    public InteractionResult tryRepaint(Player player, InteractionHand hand) {
        if (this.f_58857_ == null || !ForgeEntity.hasBrushInHand((LivingEntity)player, hand)) {
            return InteractionResult.PASS;
        }
        InteractionHand otherHand = ForgeEntity.otherHand(hand);
        BlockState sampleBlock = Block.m_49814_((Item)player.m_21120_(otherHand).m_41720_()).m_49966_();
        if (this.getTargetBlock() != sampleBlock && this.isProperSample(sampleBlock) && this.hasAllRequiredMaterials(player)) {
            if (!this.f_58857_.m_5776_()) {
                this.setTargetBlock(sampleBlock);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                if (((Boolean)requiresDye.get()).booleanValue() && !player.m_150110_().f_35937_) {
                    Inventory inventory = player.m_150109_();
                    ForgeItem.indexIn(inventory, stack -> stack.m_204117_(Tags.Items.DYES)).ifPresent(i -> inventory.m_8020_(i.intValue()).m_41774_(1));
                }
            }
            this.f_58857_.m_247517_(player, this.m_58899_(), SoundEvents.f_276624_, SoundSource.BLOCKS);
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
    }

    protected boolean hasAllRequiredMaterials(Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        Inventory inventory = player.m_150109_();
        boolean hasWater = (Boolean)requiresWaterBucket.get() == false || ForgeItem.indexIn(inventory, stack -> {
            BucketItem bucket;
            Item patt4868$temp = stack.m_41720_();
            return patt4868$temp instanceof BucketItem && (bucket = (BucketItem)patt4868$temp).getFluid().m_76145_().m_205070_(FluidTags.f_13131_);
        }).isPresent();
        boolean hasDye = (Boolean)requiresDye.get() == false || ForgeItem.indexIn(inventory, stack -> stack.m_204117_(Tags.Items.DYES)).isPresent();
        return hasWater && hasDye;
    }

    protected boolean isProperSample(BlockState sample) {
        BlockState thisBlock = this.m_58900_();
        if (this.f_58857_ != null) {
            for (Direction direction : GameWorld.Directions.of().all().toList()) {
                if (!Block.m_49918_((VoxelShape)sample.m_60768_((BlockGetter)this.f_58857_, this.m_58899_()), (Direction)direction)) continue;
                return sample.m_280296_() || ForgeBlock.isGlass(thisBlock);
            }
        }
        return false;
    }

    @Override
    public void readSharedData(CompoundTag compound) {
        HolderGetter blockGetter = (HolderGetter)Optional.ofNullable(this.f_58857_).map(lvl -> lvl.m_246945_(Registries.f_256747_)).orElse((HolderLookup)BuiltInRegistries.f_256975_.m_255303_());
        this.targetBlock = NbtUtils.m_247651_((HolderGetter)blockGetter, (CompoundTag)compound.m_128469_("target_block"));
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public CompoundTag writeSharedData(CompoundTag compound) {
        if (!this.targetBlock.m_60795_()) {
            compound.m_128365_("target_block", (Tag)NbtUtils.m_129202_((BlockState)this.targetBlock));
        }
        return compound;
    }
}

