/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public final class Biomes {
    public static final String BIOMES_LIST_SYNTAX = "Biome is specified by its registry name (case-insensitive) or by its tag with '#' prefix.\nExamples: minecraft:forest, #snowy\nEach biome must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";

    public static Stream<Biome> all() {
        return Biomes.registries().flatMap(Registry::m_123024_);
    }

    public static Stream<Registry<Biome>> registries() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return StreamSupport.stream(server.m_129785_().spliterator(), false).map(lev -> lev.m_9598_().m_6632_(Registries.f_256952_)).filter(Optional::isPresent).map(Optional::get);
        }
        return Stream.empty();
    }

    public static Stream<ResourceKey<Biome>> resourceKeys() {
        return Biomes.registries().map(Registry::m_214010_).flatMap(Collection::stream);
    }

    public static UnitConfig createConfigFor(AbstractForgeMod mod, BiomeId biome, boolean enabled) {
        String biomeName = biome.toString();
        String fileName = UnitId.from(biomeName).toConfigName();
        UnitConfig config = UnitConfig.in(Biomes.getConfigsBaseDir(mod), fileName);
        Biomes.readBiomeName(config, biomeName);
        UnitConfig.readConfigEnabled(config, enabled);
        return config;
    }

    public static Path getConfigsBaseDir(AbstractForgeMod mod) {
        return mod.getConfigsDir().resolve(Biomes.class.getSimpleName());
    }

    protected static String readBiomeName(UnitConfig config, String defaultName) {
        String name = UnitConfig.getStr(config, "Biome", "name", defaultName, "Biome registry name");
        return name;
    }

    public static BiomeId readBiomeId(UnitConfig config) {
        String name = Biomes.readBiomeName(config, "");
        if (name.isEmpty()) {
            return BiomeId.EMPTY;
        }
        return Biomes.getByName(name);
    }

    public static BiomeId getByName(String biomeName) {
        try {
            return BiomeId.from(new ResourceLocation(biomeName));
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error("Invalid biome name: '{}'", (Object)biomeName);
            return BiomeId.EMPTY;
        }
    }

    public static Stream<BiomeId> byTag(String biomeTag) {
        try {
            ResourceLocation location = new ResourceLocation(StringUtils.removeStart((String)biomeTag, (String)"#"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)location);
            return Biomes.registries().map(reg -> reg.m_203431_(tagKey)).filter(Optional::isPresent).map(Optional::get).flatMap(HolderSet.ListBacked::m_203614_).map(Holder::m_203543_).filter(Optional::isPresent).map(Optional::get).map(BiomeId::from);
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error("Invalid biome tag: '{}'", (Object)biomeTag);
            return Stream.empty();
        }
    }

    public static boolean isConfigEnabled(UnitConfig config) {
        return UnitConfig.readConfigEnabled(config, false);
    }

    public static CommonCollect.BlackWhiteList<BiomeId> from(UnitConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Biomes.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\nBiome is specified by its registry name (case-insensitive) or by its tag with '#' prefix.\nExamples: minecraft:forest, #snowy\nEach biome must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.");
        }
        ArrayList<BiomeId> black = new ArrayList<BiomeId>(Biomes.readFrom(config, category, "blackList", ""));
        ArrayList<BiomeId> white = new ArrayList<BiomeId>(Biomes.readFrom(config, category, "whiteList", ""));
        return new CommonCollect.BlackWhiteList<BiomeId>(black, white);
    }

    public static Set<BiomeId> readFrom(UnitConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptySet();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        HashSet<BiomeId> biomes = new HashSet<BiomeId>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            if (str.startsWith("#")) {
                biomes.addAll(Biomes.byTag(str).toList());
                continue;
            }
            biomes.add(Biomes.getByName(str));
        }
        return biomes;
    }
}

