/*
 * Decompiled with CFR 0.152.
 */
package com.laserbridges.mars.laserbridges;

import com.laserbridges.mars.laserbridges.LaserBridge;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaserSourceBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    protected static final VoxelShape CEILING_X_SHAPE = Block.m_49796_((double)6.5, (double)14.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.m_49796_((double)0.0, (double)14.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final VoxelShape CEILING_X_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)CEILING_X_SHAPE, (VoxelShape)Block.m_49796_((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)14.0, (double)16.0));
    protected static final VoxelShape CEILING_Z_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)CEILING_Z_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)14.0, (double)8.5));
    protected static final VoxelShape FLOOR_X_SHAPE = Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)2.0, (double)16.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)2.0, (double)9.5);
    protected static final VoxelShape FLOOR_X_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)FLOOR_X_SHAPE, (VoxelShape)Block.m_49796_((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0));
    protected static final VoxelShape FLOOR_Z_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)FLOOR_Z_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5));
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    protected static final VoxelShape NORTH_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)NORTH_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));
    protected static final VoxelShape SOUTH_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)SOUTH_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.16, (double)10.0, (double)16.0));
    protected static final VoxelShape WEST_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)WEST_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));
    protected static final VoxelShape EAST_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)EAST_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));

    public LaserSourceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> m_304657_() {
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        switch ((AttachFace)state.m_61143_(FACE)) {
            case FLOOR: {
                if (dir.m_122434_() == Direction.Axis.X) {
                    return powered ? FLOOR_X_POWERED_SHAPE : FLOOR_X_SHAPE;
                }
                return powered ? FLOOR_Z_POWERED_SHAPE : FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch (dir) {
                    case EAST: {
                        return powered ? EAST_POWERED_SHAPE : EAST_SHAPE;
                    }
                    case WEST: {
                        return powered ? WEST_POWERED_SHAPE : WEST_SHAPE;
                    }
                    case SOUTH: {
                        return powered ? SOUTH_POWERED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return powered ? NORTH_POWERED_SHAPE : NORTH_SHAPE;
            }
        }
        if (dir.m_122434_() == Direction.Axis.X) {
            return powered ? CEILING_X_POWERED_SHAPE : CEILING_X_SHAPE;
        }
        return powered ? CEILING_Z_POWERED_SHAPE : CEILING_Z_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_()) : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public void m_6861_(BlockState p_55666_, Level lvl, BlockPos p_55668_, Block p_55669_, BlockPos p_55670_, boolean p_55671_) {
        boolean flag;
        if (!lvl.f_46443_ && (flag = ((Boolean)p_55666_.m_61143_((Property)POWERED)).booleanValue()) != lvl.m_276867_(p_55668_)) {
            if (flag) {
                lvl.m_186460_(p_55668_, (Block)this, 4);
                this.MakeBridge(lvl.m_277086_(p_55668_), false, p_55666_, p_55668_, lvl);
                lvl.m_5594_((Player)null, p_55668_, (SoundEvent)LaserBridge.OFF.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            } else {
                lvl.m_7731_(p_55668_, (BlockState)p_55666_.m_61122_((Property)POWERED), 2);
                this.MakeBridge(lvl.m_277086_(p_55668_), true, p_55666_, p_55668_, lvl);
                lvl.m_5594_((Player)null, p_55668_, (SoundEvent)LaserBridge.ON.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            }
        }
    }

    public void m_6807_(BlockState p_60566_, Level p_60567_, BlockPos p_60568_, BlockState p_60569_, boolean p_60570_) {
        int redstone = p_60567_.m_277086_(p_60568_);
        if (redstone > 0) {
            p_60567_.m_5594_((Player)null, p_60568_, (SoundEvent)LaserBridge.ON.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            this.MakeBridge(p_60567_.m_277086_(p_60568_), true, p_60566_, p_60568_, p_60567_);
        }
    }

    public void m_6810_(BlockState p_60515_, Level p_60516_, BlockPos p_60517_, BlockState p_60518_, boolean p_60519_) {
        this.MakeBridge(15, false, p_60515_, p_60517_, p_60516_);
        p_60516_.m_5594_((Player)null, p_60517_, (SoundEvent)LaserBridge.OFF.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
    }

    public void MakeBridge(int strength, boolean turnOn, BlockState state, BlockPos pos, Level lvl) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        for (int i = 1; i < 15; ++i) {
            BlockPos addPos = new BlockPos(0, 0, 0);
            switch (face) {
                case FLOOR: {
                    addPos = new BlockPos(0, i, 0);
                    break;
                }
                case WALL: {
                    switch (dir) {
                        case EAST: {
                            addPos = new BlockPos(i, 0, 0);
                            break;
                        }
                        case WEST: {
                            addPos = new BlockPos(-i, 0, 0);
                            break;
                        }
                        case SOUTH: {
                            addPos = new BlockPos(0, 0, i);
                            break;
                        }
                        case NORTH: {
                            addPos = new BlockPos(0, 0, -i);
                        }
                    }
                    break;
                }
                case CEILING: {
                    addPos = new BlockPos(0, -i, 0);
                }
            }
            BlockPos nextPos = pos.m_121955_((Vec3i)addPos);
            BlockState nextState = (BlockState)((BlockState)((Block)LaserBridge.LASER_BLOCK.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_(FACE, (Comparable)face);
            if (turnOn) {
                if (i < strength && lvl.m_8055_(nextPos).m_60795_()) {
                    lvl.m_7731_(nextPos, nextState, 3);
                    continue;
                }
                return;
            }
            if (lvl.m_8055_(nextPos).equals(nextState)) {
                lvl.m_7731_(nextPos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            return;
        }
    }

    public void m_213897_(BlockState p_221937_, ServerLevel p_221938_, BlockPos p_221939_, RandomSource p_221940_) {
        if (((Boolean)p_221937_.m_61143_((Property)POWERED)).booleanValue() && !p_221938_.m_276867_(p_221939_)) {
            p_221938_.m_7731_(p_221939_, (BlockState)p_221937_.m_61122_((Property)POWERED), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{FACE});
    }
}

