/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.doors;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.ModBlockStateProperties;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.OpenedBy;
import de.geheimagentnr1.manyideas_core.elements.items.ModItemsRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.interfaces.RedstoneKeyable;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.models.Option;
import de.geheimagentnr1.manyideas_core.util.doors.BlockData;
import de.geheimagentnr1.manyideas_core.util.doors.DoorsHelper;
import de.geheimagentnr1.manyideas_core.util.doors.OpenedByHelper;
import de.geheimagentnr1.minecraft_forge_api.elements.blocks.BlockItemInterface;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class DoubleDoorBlock
extends DoorBlock
implements RedstoneKeyable,
BlockItemInterface {
    protected DoubleDoorBlock(@NotNull BlockBehaviour.Properties _properties, @NotNull BlockSetType _type, @NotNull OpenedBy openedBy) {
        super(_type, _properties.m_60955_().m_60971_((state, level, pos) -> false));
        this.initDoubleDoorBlock(openedBy);
    }

    private void initDoubleDoorBlock(@NotNull OpenedBy openedBy) {
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.m_21120_(hand).m_41720_() != ModItemsRegisterFactory.RESTONE_KEY && OpenedByHelper.canBeOpened(state, true)) {
            boolean open = (Boolean)state.m_61143_((Property)f_52727_) == false;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 10);
            DoorsHelper.playDoorSound(level, pos, this.m_278711_(), player, (Boolean)state.m_61143_((Property)f_52727_));
            BlockData neighbor = DoorsHelper.getNeighborBlock(level, pos, state);
            if (DoorsHelper.isNeighbor(state, neighbor)) {
                level.m_7731_(neighbor.getPos(), (BlockState)neighbor.getState().m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_153165_(@Nullable Entity entity, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, boolean open) {
        super.m_153165_(entity, level, state, pos, open);
        BlockData neighbor = DoorsHelper.getNeighborBlock(level, pos, state);
        if (DoorsHelper.isNeighbor(state, neighbor)) {
            level.m_7731_(neighbor.getPos(), (BlockState)neighbor.getState().m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 2);
        }
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        if (block != this && OpenedByHelper.canBeOpened(state, false)) {
            boolean isDoorPowered;
            BlockData neighbor = DoorsHelper.getNeighborBlock(level, pos, state);
            boolean isNeighbor = DoorsHelper.isNeighbor(state, neighbor);
            boolean bl = isDoorPowered = DoorsHelper.isDoorPowered(level, pos, state) || isNeighbor && DoorsHelper.isDoorPowered(level, neighbor.getPos(), neighbor.getState());
            if (isDoorPowered != (Boolean)state.m_61143_((Property)f_52729_)) {
                if ((Boolean)state.m_61143_((Property)f_52727_) != isDoorPowered) {
                    DoorsHelper.playDoorSound(level, pos, this.m_278711_(), null, isDoorPowered);
                }
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(isDoorPowered))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(isDoorPowered)), 2);
                if (isNeighbor) {
                    level.m_7731_(neighbor.getPos(), (BlockState)((BlockState)neighbor.getState().m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(isDoorPowered))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(isDoorPowered)), 2);
                }
            }
        }
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ModBlockStateProperties.OPENED_BY});
    }

    @Override
    @NotNull
    public Component getTitle() {
        return OpenedByHelper.OPEN_BY_CONTAINER_TITLE;
    }

    @Override
    @NotNull
    public ResourceLocation getIconTextures() {
        return OpenedByHelper.ICON_TEXTURES;
    }

    @Override
    @NotNull
    public List<Option> getOptions() {
        return OpenedByHelper.buildOptions();
    }

    @Override
    public int getStateIndex(@NotNull BlockState state) {
        return OpenedByHelper.getStateIndex(state);
    }

    @Override
    public void setBlockStateValue(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, int stateIndex, @NotNull Player player) {
        OpenedBy[] openedByValues = OpenedBy.values();
        if (stateIndex >= 0 && stateIndex < openedByValues.length) {
            OpenedBy openedBy = openedByValues[stateIndex];
            level.m_7731_(pos, (BlockState)state.m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 2);
            BlockData other = DoorsHelper.getOtherBlock(level, pos, state);
            level.m_7731_(other.getPos(), (BlockState)other.getState().m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 2);
            BlockData neighbor = DoorsHelper.getNeighborBlock(level, pos, state);
            if (DoorsHelper.isNeighbor(state, neighbor)) {
                level.m_7731_(neighbor.getPos(), (BlockState)neighbor.getState().m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 2);
                BlockData otherNeighbor = DoorsHelper.getOtherBlock(level, neighbor.getPos(), neighbor.getState());
                level.m_7731_(otherNeighbor.getPos(), (BlockState)otherNeighbor.getState().m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 2);
            }
        }
    }
}

