/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorTagIngredient;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorTagList;
import de.geheimagentnr1.minecraft_forge_api.elements.recipes.EnumCodec;
import de.geheimagentnr1.minecraft_forge_api.util.SimpleStringRepresentable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class ColorTagIngredientSerializer
implements IIngredientSerializer<ColorTagIngredient> {
    private static final Codec<ColorTagIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.simpleMap((Codec)new EnumCodec(Color.class), (Codec)BuiltInRegistries.f_257033_.m_194605_(), (Keyable)Keyable.forStrings(() -> Arrays.stream(Color.values()).map(SimpleStringRepresentable::m_7912_))).fieldOf("color_tag").forGetter(colorTagIngredient -> ((ColorTagList)colorTagIngredient.getIngrediant()).getStackColors())).apply((Applicative)builder, ColorTagIngredient::new));

    @NotNull
    public Codec<? extends ColorTagIngredient> codec() {
        return CODEC;
    }

    @NotNull
    public ColorTagIngredient read(@NotNull FriendlyByteBuf buffer) {
        TreeMap<ItemStack, Color> colorStacks = new TreeMap<ItemStack, Color>(Comparator.comparing(o -> BuiltInRegistries.f_257033_.m_7981_((Object)o.m_41720_())));
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            colorStacks.put(buffer.m_130267_(), Color.values()[buffer.readInt()]);
        }
        return new ColorTagIngredient(colorStacks);
    }

    public void write(@NotNull FriendlyByteBuf buffer, @NotNull ColorTagIngredient ingredient) {
        TreeMap<ItemStack, Color> colorStacks = ((ColorTagList)ingredient.getIngrediant()).getColorStacks();
        buffer.writeInt(colorStacks.size());
        colorStacks.forEach((stack, color) -> {
            buffer.m_130055_(stack);
            buffer.writeInt(color.ordinal());
        });
    }
}

