/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ColorTagList
implements ColorList {
    @NotNull
    private final TreeMap<ItemStack, Color> stacks;

    ColorTagList(@NotNull TreeMap<ItemStack, Color> _stacks) {
        this.stacks = _stacks;
    }

    ColorTagList(@NotNull Map<Color, Item> colors) {
        this.stacks = new TreeMap(Comparator.comparing(o -> BuiltInRegistries.f_257033_.m_7981_((Object)o.m_41720_())));
        colors.forEach((color, item) -> {
            if (item != Items.f_41852_) {
                this.stacks.put(new ItemStack((ItemLike)item), (Color)((Object)color));
            }
        });
    }

    @Override
    public Color getColor(@NotNull ItemStack stack) {
        return this.stacks.get(stack);
    }

    @Override
    @NotNull
    public ItemStack getStack(@NotNull Color color) {
        for (Map.Entry<ItemStack, Color> entry : this.stacks.entrySet()) {
            if (entry.getValue() != color) continue;
            return entry.getKey().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    TreeMap<ItemStack, Color> getColorStacks() {
        return this.stacks;
    }

    @NotNull
    public Map<Color, Item> getStackColors() {
        EnumMap<Color, Item> colors = new EnumMap<Color, Item>(Color.class);
        this.stacks.forEach((stack, color) -> colors.put((Color)((Object)color), stack.m_41720_()));
        return colors;
    }

    @NotNull
    public Collection<ItemStack> m_6223_() {
        return this.stacks.keySet();
    }
}

