/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlockItem;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorIngredient;
import de.geheimagentnr1.manyideas_core.util.DyeBlockHelper;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;

public abstract class DyedRecipe
implements Recipe<CraftingContainer> {
    @NotNull
    public static final String registry_name = "dyed";
    static final Codec<Item> DYE_BLOCK_ITEM_CODEC = ExtraCodecs.m_264370_((Codec)BuiltInRegistries.f_257033_.m_194605_(), item -> item instanceof DyeBlockItem ? DataResult.success((Object)item) : DataResult.error(() -> "Non DyeBlockItem result not allowed here"));
    static final Codec<ItemStack> RESULT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DYE_BLOCK_ITEM_CODEC.fieldOf("item").forGetter(ItemStack::m_41720_), (App)ExtraCodecs.m_295827_((Codec)ExtraCodecs.f_144629_, (String)"count", (Object)1).forGetter(ItemStack::m_41613_)).apply((Applicative)builder, ItemStack::new));
    @NotNull
    final NonNullList<Ingredient> ingredients;
    @NotNull
    final ItemStack result;

    DyedRecipe(@NotNull NonNullList<Ingredient> _ingredients, @NotNull ItemStack _result) {
        this.ingredients = _ingredients;
        this.result = _result;
    }

    @NotNull
    Optional<Color> findMatchingColor(@NotNull CraftingContainer inv) {
        Color color = null;
        block0: for (Ingredient ingredient : this.ingredients) {
            if (!(ingredient instanceof ColorIngredient)) continue;
            for (int j = 0; j < inv.m_6643_(); ++j) {
                if (!ingredient.test(inv.m_8020_(j))) continue;
                ColorIngredient colorIngredient = (ColorIngredient)ingredient;
                Color newColor = colorIngredient.getColor(inv.m_8020_(j));
                if (newColor == null) {
                    return Optional.empty();
                }
                if (color == null) {
                    color = newColor;
                    continue block0;
                }
                if (color == newColor) continue block0;
                return Optional.empty();
            }
        }
        return color == null ? Optional.empty() : Optional.of(color);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        Optional<Color> color = this.findMatchingColor(inv);
        return color.map(value -> DyeBlockHelper.setColorToItemStack(this.result.m_41777_(), value)).orElse(ItemStack.f_41583_);
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }
}

