/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.DyedRecipe;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.DyedShapelessRecipe;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class DyedShapelessRecipeSerializer
implements RecipeSerializer<DyedShapelessRecipe> {
    private static final int MAX_INGREDIENTS = 9;
    private static final Codec<DyedShapelessRecipe> SHAPELESS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(recipe -> {
        Object[] ingredients = (Ingredient[])recipe.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
        if (ingredients.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }, DataResult::success).forGetter(DyedShapelessRecipe::m_7527_), (App)DyedRecipe.RESULT_CODEC.fieldOf("result").forGetter(DyedRecipe::getResult)).apply((Applicative)builder, DyedShapelessRecipe::new));

    public Codec<DyedShapelessRecipe> m_292673_() {
        return SHAPELESS_CODEC;
    }

    @Nullable
    public DyedShapelessRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        int ingredientCount = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return new DyedShapelessRecipe((NonNullList<Ingredient>)ingredients, buffer.m_130267_());
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull DyedShapelessRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        buffer.m_130130_(ingredients.size());
        for (Ingredient ingredient : ingredients) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.getResult());
    }
}

