/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.special.decoration_renderer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import de.geheimagentnr1.manyideas_core.special.decoration_renderer.PlayerDecorationRenderer;
import de.geheimagentnr1.manyideas_core.special.json.JSONUtil;
import de.geheimagentnr1.minecraft_forge_api.events.ForgeEventHandlerInterface;
import de.geheimagentnr1.minecraft_forge_api.events.ModEventHandlerInterface;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlayerDecorationManager
implements ModEventHandlerInterface,
ForgeEventHandlerInterface {
    private static final Logger log = LogManager.getLogger(PlayerDecorationManager.class);
    @NotNull
    private final TreeMap<String, PlayerDecorationRenderer> DECORATION_LIST = new TreeMap();

    @NotNull
    private JsonArray loadDecorationJson() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/GeheimagentNr1/Online_Mod_Data/master/player_decorations.json");
            return (JsonArray)JSONUtil.GSON.fromJson((Reader)new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), JsonArray.class);
        }
        catch (IOException exception) {
            log.error("Failed to load Player Decorations", (Throwable)exception);
            return new JsonArray();
        }
    }

    private void readDecoration(@NotNull JsonObject jsonDecoration) {
        JsonObject jsonItems;
        log.info("Loading Player Decorations");
        String name = JSONUtil.getStringFromJson(jsonDecoration, "name");
        log.info("Read Player Decorations");
        if (name != null && (jsonItems = JSONUtil.getJsonObjectFromJson(jsonDecoration, "items")) != null) {
            JsonObject jsonVanillaItem;
            ItemStack stack = ItemStack.f_41583_;
            JsonObject jsonModdedItem = JSONUtil.getJsonObjectFromJson(jsonItems, "modded");
            if (jsonModdedItem != null) {
                stack = JSONUtil.readItemStackFromJson(jsonModdedItem);
            }
            if (stack.m_41619_() && (jsonVanillaItem = JSONUtil.getJsonObjectFromJson(jsonItems, "vanilla")) != null) {
                stack = JSONUtil.readItemStackFromJson(jsonVanillaItem);
            }
            if (!stack.m_41619_()) {
                this.DECORATION_LIST.put(name, new PlayerDecorationRenderer(stack));
            }
        }
        log.info("Initialized Player Decorations");
    }

    private void initDecorationList() {
        JsonArray jsonDecorations = this.loadDecorationJson();
        for (JsonElement element : jsonDecorations) {
            if (!element.isJsonObject()) continue;
            this.readDecoration(element.getAsJsonObject());
        }
    }

    private void renderForPlayer(@NotNull Player player, int light, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer) {
        PlayerDecorationRenderer playerDecorationRenderer = this.DECORATION_LIST.get(player.m_7755_().getString());
        if (playerDecorationRenderer != null) {
            playerDecorationRenderer.renderItemStack(player, light, poseStack, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void handleFMLClientSetupEvent(@NotNull FMLClientSetupEvent event) {
        this.initDecorationList();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void handlePreRenderPlayerEvent(@NotNull RenderPlayerEvent.Pre event) {
        if (event.getEntity() != null) {
            this.renderForPlayer(event.getEntity(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource());
        }
    }
}

