/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.util.doors;

import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.doors.DoubleDoorBlock;
import de.geheimagentnr1.manyideas_core.util.doors.BlockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoorsHelper {
    public static void playDoorSound(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockSetType type, @Nullable Player player, boolean open) {
        level.m_5594_(player, pos, open ? type.f_271141_() : type.f_271502_(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @NotNull
    public static BlockData getOtherBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockPos otherPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState otherState = level.m_8055_(otherPos);
        return new BlockData(otherPos, otherState);
    }

    @NotNull
    public static BlockData getNeighborBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockPos neighborPos = pos.m_121945_(DoorsHelper.getDirectionToNeighborDoor(state));
        BlockState neighborState = level.m_8055_(neighborPos);
        return new BlockData(neighborPos, neighborState);
    }

    public static boolean isNeighbor(@NotNull BlockState state, @NotNull BlockData neighborBlock) {
        BlockState neighborState = neighborBlock.getState();
        return neighborState.m_60734_() instanceof DoubleDoorBlock && state.m_61143_((Property)DoorBlock.f_52726_) == neighborState.m_61143_((Property)DoorBlock.f_52726_) && state.m_61143_((Property)DoorBlock.f_52728_) != neighborState.m_61143_((Property)DoorBlock.f_52728_) && state.m_61143_((Property)DoorBlock.f_52730_) == neighborState.m_61143_((Property)DoorBlock.f_52730_);
    }

    public static boolean isDoorPowered(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return level.m_276867_(pos) || level.m_276867_(pos.m_121945_(state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN));
    }

    @NotNull
    private static Direction getDirectionToNeighborDoor(@NotNull BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
        return state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_();
    }
}

