/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.util.voxel_shapes;

import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeVector;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class VoxelShapeHelper {
    @NotNull
    public static VoxelShapeVector[] vectorsToNorthVectors(@NotNull VoxelShapeVector[] vectors, @NotNull Direction facing) {
        double[][] turn_matrix;
        switch (facing) {
            case NORTH: {
                return vectors;
            }
            case EAST: {
                turn_matrix = VoxelShapeHelper.createYturnMatrix(90.0);
                break;
            }
            case SOUTH: {
                turn_matrix = VoxelShapeHelper.createYturnMatrix(180.0);
                break;
            }
            case WEST: {
                turn_matrix = VoxelShapeHelper.createYturnMatrix(270.0);
                break;
            }
            case UP: {
                turn_matrix = VoxelShapeHelper.createXturnMatrix(-90.0);
                break;
            }
            case DOWN: {
                turn_matrix = VoxelShapeHelper.createXturnMatrix(90.0);
                break;
            }
            default: {
                turn_matrix = VoxelShapeHelper.createYturnMatrix(0.0);
            }
        }
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, turn_matrix);
    }

    private static double[][] createXturnMatrix(double degree) {
        return new double[][]{{1.0, 0.0, 0.0}, {0.0, VoxelShapeHelper.cos(degree), -VoxelShapeHelper.sin(degree)}, {0.0, VoxelShapeHelper.sin(degree), VoxelShapeHelper.cos(degree)}};
    }

    private static double[][] createYturnMatrix(double degree) {
        return new double[][]{{VoxelShapeHelper.cos(degree), 0.0, VoxelShapeHelper.sin(degree)}, {0.0, 1.0, 0.0}, {-VoxelShapeHelper.sin(degree), 0.0, VoxelShapeHelper.cos(degree)}};
    }

    private static double cos(double degree) {
        degree = (degree + (double)(degree < 0.0 ? 360 : 0)) % 360.0;
        return switch ((int)degree) {
            case 0 -> 1.0;
            case 90 -> 0.0;
            case 180 -> -1.0;
            case 270 -> 0.0;
            default -> 1.0;
        };
    }

    private static double sin(double degree) {
        degree = (degree + (double)(degree < 0.0 ? 360 : 0)) % 360.0;
        return switch ((int)degree) {
            case 0 -> 0.0;
            case 90 -> 1.0;
            case 180 -> 0.0;
            case 270 -> -1.0;
            default -> 1.0;
        };
    }

    @NotNull
    private static VoxelShapeVector[] turnVoxelShapeVectors(@NotNull VoxelShapeVector[] vectors, double[][] turn_matrix) {
        VoxelShapeVector[] turned_vectors = new VoxelShapeVector[vectors.length];
        for (int i = 0; i < vectors.length; ++i) {
            turned_vectors[i] = VoxelShapeHelper.turnVoxelShapeVector(vectors[i], turn_matrix);
        }
        return turned_vectors;
    }

    @NotNull
    private static VoxelShapeVector turnVoxelShapeVector(@NotNull VoxelShapeVector vector, double[][] turn_matrix) {
        double[] vector1 = new double[]{vector.x1, vector.y1, vector.z1};
        double[] vector2 = new double[]{vector.x2, vector.y2, vector.z2};
        vector1 = VoxelShapeHelper.turnVector(vector1, turn_matrix);
        vector2 = VoxelShapeHelper.turnVector(vector2, turn_matrix);
        return VoxelShapeVector.create(vector1[0], vector1[1], vector1[2], vector2[0], vector2[1], vector2[2]);
    }

    private static double[] turnVector(double[] vector, double[][] turn_matrix) {
        double vx = vector[0] - 8.0;
        double vy = vector[1] - 8.0;
        double vz = vector[2] - 8.0;
        double x = vx * turn_matrix[0][0] + vy * turn_matrix[0][1] + vz * turn_matrix[0][2];
        double y = vx * turn_matrix[1][0] + vy * turn_matrix[1][1] + vz * turn_matrix[1][2];
        double z = vx * turn_matrix[2][0] + vy * turn_matrix[2][1] + vz * turn_matrix[2][2];
        return new double[]{x += 8.0, y += 8.0, z += 8.0};
    }

    @NotNull
    public static VoxelShapeVector[] eastVectors(@NotNull VoxelShapeVector[] vectors) {
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, VoxelShapeHelper.createYturnMatrix(-90.0));
    }

    @NotNull
    public static VoxelShapeVector[] southVectors(@NotNull VoxelShapeVector[] vectors) {
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, VoxelShapeHelper.createYturnMatrix(-180.0));
    }

    @NotNull
    public static VoxelShapeVector[] westVectors(@NotNull VoxelShapeVector[] vectors) {
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, VoxelShapeHelper.createYturnMatrix(-270.0));
    }

    @NotNull
    public static VoxelShapeVector[] upVectors(@NotNull VoxelShapeVector[] vectors) {
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, VoxelShapeHelper.createXturnMatrix(90.0));
    }

    @NotNull
    public static VoxelShapeVector[] downVectors(@NotNull VoxelShapeVector[] vectors) {
        return VoxelShapeHelper.turnVoxelShapeVectors(vectors, VoxelShapeHelper.createXturnMatrix(-90.0));
    }

    @NotNull
    public static VoxelShape vectorsToVoxelShape(@NotNull VoxelShapeVector[] vectors) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (VoxelShapeVector vector : vectors) {
            shapes.add(Block.m_49796_((double)Math.min(vector.x1, vector.x2), (double)Math.min(vector.y1, vector.y2), (double)Math.min(vector.z1, vector.z2), (double)Math.max(vector.x1, vector.x2), (double)Math.max(vector.y1, vector.y2), (double)Math.max(vector.z1, vector.z2)));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }
}

