/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_doors.elements.blocks.player_door_sensor;

import com.mojang.serialization.MapCodec;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.BlockSide;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.ModBlockStateProperties;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.interfaces.RedstoneKeyable;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.models.Option;
import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeMemory;
import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeVector;
import de.geheimagentnr1.manyideas_doors.elements.blocks.ModBlocksRegisterFactory;
import de.geheimagentnr1.manyideas_doors.elements.blocks.player_door_sensor.PlayerDoorSensorEntity;
import de.geheimagentnr1.minecraft_forge_api.elements.blocks.BlockItemInterface;
import de.geheimagentnr1.minecraft_forge_api.util.TranslationKeyHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PlayerDoorSensor
extends BaseEntityBlock
implements BlockItemInterface,
RedstoneKeyable {
    @NotNull
    public static final String registry_name = "player_door_sensor";
    @NotNull
    public static final MapCodec<PlayerDoorSensor> CODEC = PlayerDoorSensor.m_306223_(properties -> new PlayerDoorSensor());
    @NotNull
    static final IntegerProperty SENSOR_RANGE = IntegerProperty.m_61631_((String)"sensor_range", (int)1, (int)3);
    @NotNull
    private static final Component SENSOR_RANGE_CONTAINER_TITLE = TranslationKeyHelper.generateMessageTranslationTextComponent((String)"manyideas_doors", (String)"sensor_range");
    @NotNull
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("manyideas_core", "textures/gui/redstone_key/icons/icons_numbers.png");
    @NotNull
    private static final VoxelShapeMemory SINGLE = VoxelShapeMemory.createHorizontalVoxelShapes((Direction)Direction.NORTH, (VoxelShapeVector[])new VoxelShapeVector[]{VoxelShapeVector.create((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.5, (double)1.5)});
    @NotNull
    private static final VoxelShapeMemory LEFT = VoxelShapeMemory.createHorizontalVoxelShapes((Direction)Direction.NORTH, (VoxelShapeVector[])new VoxelShapeVector[]{VoxelShapeVector.create((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)1.5)});
    @NotNull
    private static final VoxelShapeMemory MIDDLE = VoxelShapeMemory.createHorizontalVoxelShapes((Direction)Direction.NORTH, (VoxelShapeVector[])new VoxelShapeVector[]{VoxelShapeVector.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)1.5)});
    @NotNull
    private static final VoxelShapeMemory RIGHT = VoxelShapeMemory.createHorizontalVoxelShapes((Direction)Direction.NORTH, (VoxelShapeVector[])new VoxelShapeVector[]{VoxelShapeVector.create((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)1.5, (double)1.5)});

    public PlayerDoorSensor() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60978_(5.0f).m_60999_().m_60955_().m_60971_((state, level, pos) -> false).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SENSOR_RANGE, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        return switch ((BlockSide)state.m_61143_((Property)ModBlockStateProperties.BLOCK_SIDE)) {
            default -> throw new IncompatibleClassChangeError();
            case BlockSide.SINGLE -> SINGLE.getShapeFromHorizontalFacing(facing);
            case BlockSide.LEFT -> LEFT.getShapeFromHorizontalFacing(facing);
            case BlockSide.MIDDLE -> MIDDLE.getShapeFromHorizontalFacing(facing);
            case BlockSide.RIGHT -> RIGHT.getShapeFromHorizontalFacing(facing);
        };
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PlayerDoorSensorEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : PlayerDoorSensor.m_152132_(blockEntityType, ModBlocksRegisterFactory.PLAYER_DOOR_SENSOR_ENTITY, PlayerDoorSensorEntity::tick);
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction side) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? 15 : 0;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return this.setProperties((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_()), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        BlockState newState = this.setProperties(state, level, currentPos);
        if (facingState.m_60734_() == this) {
            return (BlockState)newState.m_61124_((Property)SENSOR_RANGE, (Comparable)((Integer)facingState.m_61143_((Property)SENSOR_RANGE)));
        }
        return newState;
    }

    private BlockState setProperties(BlockState stateIn, LevelAccessor level, BlockPos currentPos) {
        boolean rightBlockIsPlayerDoorSensor;
        Direction direction = (Direction)stateIn.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState leftState = level.m_8055_(currentPos.m_121945_(direction.m_122428_()));
        BlockState rightState = level.m_8055_(currentPos.m_121945_(direction.m_122427_()));
        boolean leftBlockIsPlayerDoorSensor = leftState.m_60734_() == ModBlocksRegisterFactory.PLAYER_DOOR_SENSOR && leftState.m_61143_((Property)BlockStateProperties.f_61374_) == direction;
        boolean bl = rightBlockIsPlayerDoorSensor = rightState.m_60734_() == ModBlocksRegisterFactory.PLAYER_DOOR_SENSOR && rightState.m_61143_((Property)BlockStateProperties.f_61374_) == direction;
        if (leftBlockIsPlayerDoorSensor) {
            if (rightBlockIsPlayerDoorSensor) {
                return (BlockState)((BlockState)stateIn.m_61124_((Property)ModBlockStateProperties.BLOCK_SIDE, (Comparable)BlockSide.MIDDLE)).m_61124_((Property)SENSOR_RANGE, (Comparable)((Integer)leftState.m_61143_((Property)SENSOR_RANGE)));
            }
            return (BlockState)((BlockState)stateIn.m_61124_((Property)ModBlockStateProperties.BLOCK_SIDE, (Comparable)BlockSide.RIGHT)).m_61124_((Property)SENSOR_RANGE, (Comparable)((Integer)leftState.m_61143_((Property)SENSOR_RANGE)));
        }
        if (rightBlockIsPlayerDoorSensor) {
            return (BlockState)((BlockState)stateIn.m_61124_((Property)ModBlockStateProperties.BLOCK_SIDE, (Comparable)BlockSide.LEFT)).m_61124_((Property)SENSOR_RANGE, (Comparable)((Integer)rightState.m_61143_((Property)SENSOR_RANGE)));
        }
        return (BlockState)stateIn.m_61124_((Property)ModBlockStateProperties.BLOCK_SIDE, (Comparable)BlockSide.SINGLE);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        this.notifyNeighbors(level, pos, (Block)this, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61448_, ModBlockStateProperties.BLOCK_SIDE, SENSOR_RANGE});
    }

    void notifyNeighbors(@NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull Direction facing) {
        level.m_46672_(pos, block);
        level.m_46672_(pos.m_121945_(facing), block);
    }

    @NotNull
    public Component getTitle() {
        return SENSOR_RANGE_CONTAINER_TITLE;
    }

    @NotNull
    public ResourceLocation getIconTextures() {
        return ICON_TEXTURES;
    }

    @NotNull
    public List<Option> getOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Integer range : SENSOR_RANGE.m_6908_()) {
            options.add(new Option(TranslationKeyHelper.generateMessageTranslationKey((String)"manyideas_doors", (String)(range + ".title")), TranslationKeyHelper.generateMessageTranslationKey((String)"manyideas_doors", (String)(range + ".description"))));
        }
        return options;
    }

    public int getStateIndex(@NotNull BlockState state) {
        return (Integer)state.m_61143_((Property)SENSOR_RANGE) - 1;
    }

    public void setBlockStateValue(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, int stateIndex, @NotNull Player player) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SENSOR_RANGE, (Comparable)Integer.valueOf(stateIndex + 1)), 3);
    }
}

