/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.Easing;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FastRunningAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(FastRun.class).isDoing();
    }

    private float bodyAngleFactor(float phase) {
        return new Easing(phase).squareOut(0.0f, 1.0f, 0.0f, 1.0f).get();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float bodyAngleFactor = this.bodyAngleFactor(phase);
        double rightXRotFactor = Math.cos((double)transformer.getLimbSwing() * 0.6662 + Math.PI);
        double leftXRotFactor = Math.cos((double)transformer.getLimbSwing() * 0.6662);
        transformer.getRawModel().f_102812_.f_104202_ += (float)(leftXRotFactor * 2.0);
        transformer.getRawModel().f_102811_.f_104202_ += (float)(rightXRotFactor * 2.0);
        transformer.getRawModel().f_102812_.f_104200_ -= (float)Math.abs(leftXRotFactor);
        transformer.getRawModel().f_102811_.f_104200_ += (float)Math.abs(rightXRotFactor);
        transformer.getRawModel().f_102812_.f_104201_ += bodyAngleFactor * 0.8f;
        transformer.getRawModel().f_102811_.f_104201_ += bodyAngleFactor * 0.8f;
        transformer.getRawModel().f_102814_.f_104201_ += (float)Math.min(0.0, (double)transformer.getRawModel().f_102814_.f_104203_ / 1.5707963267948966);
        transformer.getRawModel().f_102813_.f_104201_ += (float)Math.min(0.0, (double)transformer.getRawModel().f_102813_.f_104203_ / 1.5707963267948966);
        transformer.getRawModel().f_102814_.f_104202_ += (float)((double)transformer.getRawModel().f_102814_.f_104203_ / 1.0471975511965976);
        transformer.getRawModel().f_102813_.f_104202_ += (float)((double)transformer.getRawModel().f_102813_.f_104203_ / 1.0471975511965976);
        float tick = (float)this.getTick() + transformer.getPartialTick();
        transformer.rotateRightArm((float)(Math.toRadians(-20.0f * bodyAngleFactor) + rightXRotFactor * (double)transformer.getLimbSwingAmount()), 0.0f, (float)Math.toRadians((double)(bodyAngleFactor * 15.0f) + (1.0 + Math.cos((double)transformer.getLimbSwing() * 1.3324 + Math.PI)) / 2.0 * Math.sin((double)transformer.getLimbSwing() * 1.3324 + Math.PI) * 17.0)).rotateLeftArm((float)(Math.toRadians(-20.0f * bodyAngleFactor) + leftXRotFactor * (double)transformer.getLimbSwingAmount()), 0.0f, (float)Math.toRadians((double)(bodyAngleFactor * -15.0f) + (1.0 + Math.cos((double)transformer.getLimbSwing() * 1.3324)) / 2.0 * Math.sin((double)transformer.getLimbSwing() * 1.3324) * -17.0)).rotateAdditionallyHeadPitch(bodyAngleFactor * -30.0f - 5.0f * (float)Math.sin(Math.PI * (double)tick / 10.0)).addRotateRightLeg((float)Math.toRadians(-15.0f * bodyAngleFactor), 0.0f, 0.0f).addRotateLeftLeg((float)Math.toRadians(-15.0f * bodyAngleFactor), 0.0f, 0.0f).end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float tick = (float)this.getTick() + rotator.getPartialTick();
        float phase = tick / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float pitch = this.bodyAngleFactor(phase) * 25.0f + 5.0f * (float)Math.sin(Math.PI * (double)tick / 10.0);
        Vec3 lookAngle = player.m_20154_();
        Vec3 bodyAngle = VectorUtil.fromYawDegree(MathUtil.lerp(player.f_20884_, player.f_20883_, rotator.getPartialTick()));
        Vec3 differenceVec = new Vec3(lookAngle.m_7096_() * bodyAngle.m_7096_() + lookAngle.m_7094_() * bodyAngle.m_7094_(), 0.0, -lookAngle.m_7096_() * bodyAngle.m_7094_() + lookAngle.m_7094_() * bodyAngle.m_7096_()).m_82541_();
        rotator.startBasedCenter().rotatePitchFrontward(pitch).rotateRollRightward((float)(30.0 * (double)phase * Math.asin(differenceVec.m_7094_()))).end();
    }
}

