/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.client.hud.impl.StaminaHUD;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;

public class LightStaminaHUD {
    private long lastStaminaChangedTick = 0L;
    private int lastChangingSign = 0;
    private int changingSign = 0;
    private long changingTimeTick = 0L;
    private int randomOffset = 0;
    private boolean justBecameMax = false;

    public void onTick(TickEvent.ClientTickEvent event, LocalPlayer player) {
        IStamina stamina = IStamina.get((Player)player);
        if (stamina == null) {
            return;
        }
        this.changingSign = (int)Math.signum(stamina.get() - stamina.getOldValue());
        long gameTime = player.m_20193_().m_46467_();
        if (this.changingSign != this.lastChangingSign) {
            this.lastChangingSign = this.changingSign;
            this.changingTimeTick = 0L;
        } else {
            ++this.changingTimeTick;
        }
        this.randomOffset = player.m_217043_().m_188503_(5) == 0 ? (this.randomOffset += player.m_217043_().m_188499_() ? 1 : -1) : 0;
        if (stamina.get() != stamina.getOldValue() || stamina.isExhausted()) {
            this.lastStaminaChangedTick = gameTime;
        }
        this.justBecameMax = stamina.getOldValue() < stamina.get() && stamina.get() == stamina.getActualMaxStamina();
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_7500_()) {
            return;
        }
        IStamina stamina = IStamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        if (ParCoolConfig.Client.Booleans.HideStaminaHUDWhenStaminaIsInfinite.get().booleanValue() && parkourability.getActionInfo().isStaminaInfinite(player.m_7500_() || player.m_5833_())) {
            return;
        }
        long gameTime = player.m_20193_().m_46467_();
        if (gameTime - this.lastStaminaChangedTick > 40L) {
            return;
        }
        float staminaScale = (float)stamina.get() / (float)stamina.getActualMaxStamina();
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        staminaScale *= 10.0f;
        Minecraft mc = Minecraft.m_91087_();
        int baseX = width / 2 + 92;
        int baseY = height - gui.rightHeight;
        boolean exhausted = stamina.isExhausted();
        for (int i = 0; i < 10; ++i) {
            int textureX;
            int x = baseX - i * 8 - 9;
            int offsetY = 0;
            int n = textureX = exhausted ? 27 : 0;
            if (this.justBecameMax) {
                textureX = 81;
            } else if (staminaScale <= (float)i) {
                textureX += 18;
            } else if (staminaScale < (float)i + 0.5f) {
                textureX += 9;
            }
            if (this.justBecameMax) {
                offsetY = -1;
            } else if (this.changingSign == 1) {
                if ((this.changingTimeTick & 0x1FL) == (long)i) {
                    offsetY = -1;
                }
            } else if ((float)(i + 1) > staminaScale && staminaScale > (float)i && this.changingSign == -1) {
                offsetY = this.randomOffset;
            }
            graphics.m_280163_(StaminaHUD.STAMINA, x, baseY + offsetY, (float)textureX, 119.0f, 9, 9, 129, 128);
        }
        gui.rightHeight += 10;
    }
}

