/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.DiveAnimationHostAnimator;
import com.alrex.parcool.client.animation.impl.DiveIntoWaterAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.SkyDive;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Dive
extends Action {
    private boolean justJumped = false;
    private double initialYVelocityOfLastJump = 0.42;
    private double playerYSpeedOld = 0.0;
    private double playerYSpeed = 0.0;
    private int fallingTick = 0;

    public double getPlayerYSpeed(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.playerYSpeedOld, (double)this.playerYSpeed);
    }

    @Override
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.playerYSpeedOld = this.playerYSpeed;
        this.playerYSpeed = player.m_20184_().m_7098_();
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.fallingTick = this.isDoing() && (this.playerYSpeed < 0.0 || this.fallingTick > 0) ? ++this.fallingTick : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean startInAir;
        boolean bl = startInAir = player.m_20184_().m_7098_() < 0.0 && parkourability.getAdditionalProperties().getNotLandingTick() > 10 && parkourability.getAdditionalProperties().getNotInWaterTick() > 30 && KeyRecorder.keyJumpState.getTickKeyDown() > 10 && WorldUtil.existsSpaceBelow((LivingEntity)player);
        if (!(startInAir || this.justJumped && WorldUtil.existsDivableSpace((LivingEntity)player) && parkourability.get(FastRun.class).canActWithRunning(player))) {
            this.justJumped = false;
            return false;
        }
        startInfo.putDouble(this.initialYVelocityOfLastJump);
        BufferUtil.wrap(startInfo).putBoolean(startInAir);
        this.justJumped = false;
        return parkourability.getActionInfo().can(Dive.class) && !stamina.isExhausted() && !parkourability.get(Crawl.class).isDoing() && !player.m_20143_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !(player.m_21255_() || player.m_150110_().f_35935_ || player.m_20072_() || player.m_20077_() || player.m_6069_() || player.m_20096_() || this.fallingTick > 5 && (double)player.f_19789_ < 0.1 || stamina.isExhausted());
    }

    public void onJump(Player player, Parkourability parkourability, IStamina stamina) {
        if (!player.m_7578_()) {
            return;
        }
        this.initialYVelocityOfLastJump = player.m_20184_().m_7098_();
        this.justJumped = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double initialYSpeed;
        this.playerYSpeedOld = this.playerYSpeed = (initialYSpeed = startData.getDouble());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DiveAnimationHostAnimator(initialYSpeed, BufferUtil.getBoolean(startData)));
        }
    }

    @Override
    public void onStop(Player player) {
        if (player.m_20072_()) {
            Animation animation = Animation.get(player);
            Parkourability parkourability = Parkourability.get(player);
            if (animation != null && parkourability != null && parkourability.getAdditionalProperties().getNotLandingTick() >= 5 && player.m_20184_().m_7098_() < 0.0) {
                animation.setAnimator(new DiveIntoWaterAnimator(parkourability.get(SkyDive.class).isDoing()));
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putDouble(this.playerYSpeed).putDouble(this.playerYSpeedOld);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.playerYSpeed = buffer.getDouble();
        this.playerYSpeedOld = buffer.getDouble();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        double initialYSpeed;
        this.playerYSpeed = this.initialYVelocityOfLastJump = (initialYSpeed = startData.getDouble());
        this.playerYSpeedOld = this.initialYVelocityOfLastJump;
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DiveAnimationHostAnimator(initialYSpeed, BufferUtil.getBoolean(startData)));
        }
    }
}

