/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.CrawlAnimator;
import com.alrex.parcool.client.animation.impl.SlidingAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class Slide
extends Action {
    private Vec3 slidingVec = null;

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return !stamina.isExhausted() && parkourability.getActionInfo().can(Slide.class) && KeyRecorder.keyCrawlState.isPressed() && player.m_20096_() && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Tap.class).isDoing() && parkourability.get(Crawl.class).isDoing() && !player.m_20072_() && parkourability.get(FastRun.class).getDashTick(parkourability.getAdditionalProperties()) > 5;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        int maxSlidingTick = ParCoolConfig.Client.Integers.SlidingContinuableTick.get();
        ActionInfo info = parkourability.getActionInfo();
        if (info.getServerLimitation().isEnabled()) {
            maxSlidingTick = Math.min(maxSlidingTick, info.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxSlidingContinuableTick));
        }
        if (info.getIndividualLimitation().isEnabled()) {
            maxSlidingTick = Math.min(maxSlidingTick, info.getIndividualLimitation().get(ParCoolConfig.Server.Integers.MaxSlidingContinuableTick));
        }
        return this.getDoingTick() < maxSlidingTick && parkourability.get(Crawl.class).isDoing();
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.slidingVec = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.SLIDE.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new SlidingAnimator());
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new SlidingAnimator());
        }
    }

    @Override
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.slidingVec != null) {
            AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
            double speedScale = 0.45;
            if (attr != null) {
                speedScale = attr.m_22135_() * 4.5;
            }
            Vec3 vec = this.slidingVec.m_82490_(speedScale);
            player.m_20256_((player.m_20096_() ? vec : vec.m_82490_(0.6)).m_82520_(0.0, player.m_20184_().m_7098_(), 0.0));
        }
    }

    @Override
    public void onStopInLocalClient(Player player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Override
    public void onStopInOtherClient(Player player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.slidingVec == null || !this.isDoing()) {
            return;
        }
        player.m_146922_((float)VectorUtil.toYawDegree(this.slidingVec));
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }
}

