/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientInformation {
    private boolean synced = false;
    private final boolean[] actionPossibilities = new boolean[ActionList.ACTIONS.size()];
    private final int[] staminaConsumptions = new int[ActionList.ACTIONS.size()];
    private final EnumMap<ParCoolConfig.Client.Booleans, Boolean> booleans = new EnumMap(ParCoolConfig.Client.Booleans.class);
    private final EnumMap<ParCoolConfig.Client.Integers, Integer> integers = new EnumMap(ParCoolConfig.Client.Integers.class);
    private final EnumMap<ParCoolConfig.Client.Doubles, Double> doubles = new EnumMap(ParCoolConfig.Client.Doubles.class);

    public boolean getPossibilityOf(Class<? extends Action> action) {
        if (!this.synced) {
            return false;
        }
        return this.actionPossibilities[ActionList.getIndexOf(action)];
    }

    public int getStaminaConsumptionOf(Class<? extends Action> action) {
        if (!this.synced) {
            return 0;
        }
        return this.staminaConsumptions[ActionList.getIndexOf(action)];
    }

    public Boolean get(ParCoolConfig.Client.Booleans item) {
        if (!this.synced) {
            return item.DefaultValue;
        }
        Boolean value = this.booleans.get(item);
        return value == null ? item.DefaultValue : value;
    }

    public Integer get(ParCoolConfig.Client.Integers item) {
        if (!this.synced) {
            return item.DefaultValue;
        }
        Integer value = this.integers.get(item);
        return value == null ? item.DefaultValue : value;
    }

    public Double get(ParCoolConfig.Client.Doubles item) {
        if (!this.synced) {
            return item.DefaultValue;
        }
        Double value = this.doubles.get(item);
        return value == null ? item.DefaultValue : value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readFromLocalConfig() {
        for (int i = 0; i < this.actionPossibilities.length; ++i) {
            this.actionPossibilities[i] = (Boolean)ParCoolConfig.Client.getPossibilityOf(ActionList.ACTIONS.get(i)).get();
            this.staminaConsumptions[i] = (Integer)ParCoolConfig.Client.getStaminaConsumptionOf(ActionList.ACTIONS.get(i)).get();
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            this.booleans.put(booleans, booleans.get());
        }
        for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
            this.integers.put((ParCoolConfig.Client.Integers)enum_, ((ParCoolConfig.Client.Integers)enum_).get());
        }
        for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
            this.doubles.put((ParCoolConfig.Client.Doubles)enum_, ((ParCoolConfig.Client.Doubles)enum_).get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void writeTo(ByteBuffer buffer) {
        for (boolean bl : this.actionPossibilities) {
            buffer.put((byte)(bl ? 1 : 0));
        }
        for (int n : this.staminaConsumptions) {
            buffer.putInt(n);
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            booleans.writeToBuffer(buffer);
        }
        for (ParCoolConfig.Client.Integers integers : ParCoolConfig.Client.Integers.values()) {
            integers.writeToBuffer(buffer);
        }
        for (ParCoolConfig.Client.Doubles doubles : ParCoolConfig.Client.Doubles.values()) {
            doubles.writeToBuffer(buffer);
        }
    }

    public void readFrom(ByteBuffer buffer) {
        int i;
        for (i = 0; i < this.actionPossibilities.length; ++i) {
            this.actionPossibilities[i] = buffer.get() != 0;
        }
        for (i = 0; i < this.staminaConsumptions.length; ++i) {
            this.staminaConsumptions[i] = buffer.getInt();
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            this.booleans.put(booleans, booleans.readFromBuffer(buffer));
        }
        for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
            this.integers.put((ParCoolConfig.Client.Integers)enum_, ((ParCoolConfig.Client.Integers)enum_).readFromBuffer(buffer));
        }
        for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
            this.doubles.put((ParCoolConfig.Client.Doubles)enum_, ((ParCoolConfig.Client.Doubles)enum_).readFromBuffer(buffer));
        }
    }

    public void setSynced(boolean status) {
        this.synced = status;
    }
}

