/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionLimitation;
import com.alrex.parcool.common.network.SyncLimitationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Limitations {
    private boolean haveReceived = false;
    private boolean enabled = false;
    private final EnumMap<ParCoolConfig.Server.Booleans, Boolean> booleans = new EnumMap(ParCoolConfig.Server.Booleans.class);
    private final EnumMap<ParCoolConfig.Server.Integers, Integer> integers = new EnumMap(ParCoolConfig.Server.Integers.class);
    private final EnumMap<ParCoolConfig.Server.Doubles, Double> doubles = new EnumMap(ParCoolConfig.Server.Doubles.class);
    private final ActionLimitation[] actionLimitations = new ActionLimitation[ActionList.ACTIONS.size()];

    public Limitations() {
        for (int i = 0; i < this.actionLimitations.length; ++i) {
            this.actionLimitations[i] = new ActionLimitation(true, 0);
        }
    }

    public boolean isReceived() {
        return this.haveReceived;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPermitted(Class<? extends Action> action) {
        if (!this.haveReceived) {
            return false;
        }
        if (!this.enabled) {
            return true;
        }
        ActionLimitation limitation = this.actionLimitations[ActionList.getIndexOf(action)];
        if (limitation == null) {
            return false;
        }
        return limitation.isPossible();
    }

    public int getLeastStaminaConsumption(Class<? extends Action> action) {
        if (!this.haveReceived) {
            return 0;
        }
        if (!this.enabled) {
            return 0;
        }
        ActionLimitation limitation = this.actionLimitations[ActionList.getIndexOf(action)];
        if (limitation == null) {
            return 0;
        }
        return limitation.getLeastStaminaConsumption();
    }

    public boolean get(ParCoolConfig.Server.Booleans item) {
        if (!this.haveReceived) {
            return !item.DefaultValue;
        }
        if (!this.enabled) {
            return item.DefaultValue;
        }
        Boolean value = this.booleans.get(item);
        if (value == null) {
            return item.DefaultValue;
        }
        return value;
    }

    public int get(ParCoolConfig.Server.Integers item) {
        if (!this.haveReceived) {
            return 0;
        }
        if (!this.enabled) {
            return item.DefaultValue;
        }
        Integer value = this.integers.get(item);
        if (value == null) {
            return item.DefaultValue;
        }
        return value;
    }

    public double get(ParCoolConfig.Server.Doubles item) {
        if (!this.haveReceived) {
            return 0.0;
        }
        if (!this.enabled) {
            return item.DefaultValue;
        }
        Double value = this.doubles.get(item);
        if (value == null) {
            return item.DefaultValue;
        }
        return value;
    }

    public boolean isInfiniteStaminaPermitted() {
        return !this.enabled || this.booleans.get(ParCoolConfig.Server.Booleans.AllowInfiniteStamina) != false;
    }

    public void readFromServerConfig() {
        this.enabled = (Boolean)ParCoolConfig.Server.LimitationEnabled.get();
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            this.booleans.put(booleans, booleans.get());
        }
        for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
            this.integers.put((ParCoolConfig.Server.Integers)enum_, ((ParCoolConfig.Server.Integers)enum_).get());
        }
        for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
            this.doubles.put((ParCoolConfig.Server.Doubles)enum_, ((ParCoolConfig.Server.Doubles)enum_).get());
        }
        for (int i = 0; i < this.actionLimitations.length; ++i) {
            this.actionLimitations[i] = new ActionLimitation(ParCoolConfig.Server.getPermissionOf(ActionList.getByIndex(i)), ParCoolConfig.Server.getLeastStaminaConsumptionOf(ActionList.getByIndex(i)));
        }
    }

    public void setReceived() {
        this.haveReceived = true;
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.enabled ? 1 : 0));
        for (ActionLimitation actionLimitation : this.actionLimitations) {
            buffer.put((byte)(actionLimitation.isPossible() ? 1 : 0)).putInt(actionLimitation.getLeastStaminaConsumption());
        }
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            buffer.put((byte)(this.get(booleans) ? 1 : 0));
        }
        for (ParCoolConfig.Server.Integers integers : ParCoolConfig.Server.Integers.values()) {
            buffer.putInt(this.get(integers));
        }
        for (ParCoolConfig.Server.Doubles doubles : ParCoolConfig.Server.Doubles.values()) {
            buffer.putDouble(this.get(doubles));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readFrom(ByteBuffer buffer) {
        this.enabled = buffer.get() != 0;
        for (int i = 0; i < this.actionLimitations.length; ++i) {
            this.actionLimitations[i] = new ActionLimitation(buffer.get() != 0, buffer.getInt());
        }
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            this.booleans.put(booleans, buffer.get() != 0);
        }
        for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
            this.integers.put((ParCoolConfig.Server.Integers)enum_, buffer.getInt());
        }
        for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
            this.doubles.put((ParCoolConfig.Server.Doubles)enum_, buffer.getDouble());
        }
        this.setReceived();
    }

    public Tag writeTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("limitation_imposed", this.enabled);
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            nbt.m_128379_(booleans.Path, this.get(booleans));
        }
        for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
            nbt.m_128405_(((ParCoolConfig.Server.Integers)enum_).Path, this.get((ParCoolConfig.Server.Integers)enum_));
        }
        for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
            nbt.m_128347_(((ParCoolConfig.Server.Doubles)enum_).Path, this.get((ParCoolConfig.Server.Doubles)enum_));
        }
        ListTag limitationList = new ListTag();
        for (int i = 0; i < this.actionLimitations.length; ++i) {
            ActionLimitation limitation = this.actionLimitations[i];
            if (limitation == null) continue;
            Class<? extends Action> clazz = ActionList.getByIndex(i);
            CompoundTag actionNbt = new CompoundTag();
            actionNbt.m_128359_("action_name", clazz.getSimpleName());
            actionNbt.m_128379_("action_permitted", limitation.isPossible());
            actionNbt.m_128405_("action_stamina_consumption", limitation.getLeastStaminaConsumption());
            limitationList.add((Object)actionNbt);
            nbt.m_128344_("list_type", limitationList.m_7264_());
        }
        nbt.m_128365_("actions", (Tag)limitationList);
        return nbt;
    }

    public void readTag(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundNBT = (CompoundTag)nbt;
            this.enabled = compoundNBT.m_128471_("limitation_imposed");
            for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
                this.booleans.put(booleans, compoundNBT.m_128471_(booleans.Path));
            }
            for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
                this.integers.put((ParCoolConfig.Server.Integers)enum_, compoundNBT.m_128451_(((ParCoolConfig.Server.Integers)enum_).Path));
            }
            for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
                this.doubles.put((ParCoolConfig.Server.Doubles)enum_, compoundNBT.m_128459_(((ParCoolConfig.Server.Doubles)enum_).Path));
            }
            for (Tag inbt : compoundNBT.m_128437_("actions", (int)compoundNBT.m_128445_("list_type"))) {
                int n;
                if (!(inbt instanceof CompoundTag)) continue;
                CompoundTag actionNbt = (CompoundTag)inbt;
                String name = actionNbt.m_128461_("action_name");
                for (n = 0; n < ActionList.ACTIONS.size() && !name.equals(ActionList.getByIndex(n).getSimpleName()); ++n) {
                }
                if (n == ActionList.ACTIONS.size()) continue;
                this.actionLimitations[n] = new ActionLimitation(actionNbt.m_128471_("action_permitted"), actionNbt.m_128451_("action_stamina_consumption"));
            }
        } else {
            throw new IllegalArgumentException("NBT for Limitation, is not CompoundTag");
        }
    }

    public static class Changer {
        final Limitations instance;
        final ServerPlayer player;

        public static Changer get(ServerPlayer player) {
            return new Changer(Parkourability.get((Player)player).getActionInfo().getIndividualLimitation(), player);
        }

        Changer(Limitations limitations, ServerPlayer player) {
            this.instance = limitations;
            this.player = player;
        }

        public Changer set(ParCoolConfig.Server.Booleans item, boolean value) {
            this.instance.booleans.put(item, value);
            return this;
        }

        public Changer set(ParCoolConfig.Server.Integers item, int value) {
            this.instance.integers.put(item, value);
            return this;
        }

        public Changer set(ParCoolConfig.Server.Doubles item, double value) {
            this.instance.doubles.put(item, value);
            return this;
        }

        public Changer setEnabled(boolean value) {
            this.instance.enabled = value;
            return this;
        }

        public Changer setPossibilityOf(Class<? extends Action> action, boolean value) {
            short index = ActionList.getIndexOf(action);
            this.instance.actionLimitations[index] = new ActionLimitation(value, this.instance.actionLimitations[index].getLeastStaminaConsumption());
            return this;
        }

        public Changer setLeastStaminaConsumption(Class<? extends Action> action, int value) {
            short index = ActionList.getIndexOf(action);
            this.instance.actionLimitations[index] = new ActionLimitation(this.instance.actionLimitations[index].isPossible(), value);
            return this;
        }

        public Changer setAllDefault() {
            for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
                this.instance.booleans.put(booleans, booleans.DefaultValue);
            }
            for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
                this.instance.integers.put((ParCoolConfig.Server.Integers)enum_, ((ParCoolConfig.Server.Integers)enum_).DefaultValue);
            }
            for (int i = 0; i < this.instance.actionLimitations.length; ++i) {
                this.instance.actionLimitations[i] = new ActionLimitation(true, 0);
            }
            return this;
        }

        public void sync() {
            if (this.instance == null) {
                return;
            }
            SyncLimitationMessage.sendIndividualLimitation(this.player);
        }
    }
}

