/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v3.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.core.v1.utility.NbtSerializable;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class CapabilityComponent<T>
implements NbtSerializable {
    private boolean initialized;
    private CapabilityKey<T, CapabilityComponent<T>> capabilityKey;
    private T holder;

    protected final T getHolder() {
        Objects.requireNonNull(this.holder, "holder is null");
        return this.holder;
    }

    @ApiStatus.Internal
    public final void initialize(CapabilityKey<T, CapabilityComponent<T>> capabilityKey, T holder) {
        if (this.initialized) {
            throw new IllegalStateException("Capability component '%s' already initialized".formatted(capabilityKey.identifier()));
        }
        this.initialized = true;
        Objects.requireNonNull(capabilityKey, "capability key is null");
        this.capabilityKey = capabilityKey;
        Objects.requireNonNull(holder, "capability holder is null");
        this.holder = holder;
    }

    @MustBeInvokedByOverriders
    public void setChanged() {
        this.capabilityKey.setChanged(this);
    }

    @Override
    public void write(CompoundTag tag) {
    }

    @Override
    public void read(CompoundTag tag) {
    }
}

