/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v3.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CopyStrategy {
    ALWAYS{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            this.copy(oldCapability, newCapability);
        }
    }
    ,
    NEVER{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            if (originalStillAlive) {
                this.copy(oldCapability, newCapability);
            }
        }
    }
    ,
    KEEP_PLAYER_INVENTORY{

        @Override
        public void copy(Entity oldEntity, CapabilityComponent<?> oldCapability, Entity newEntity, CapabilityComponent<?> newCapability, boolean originalStillAlive) {
            if (originalStillAlive) {
                this.copy(oldCapability, newCapability);
            } else if (oldEntity instanceof Player && newEntity instanceof Player && newEntity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                this.copy(oldCapability, newCapability);
            }
        }
    };


    public abstract void copy(Entity var1, CapabilityComponent<?> var2, Entity var3, CapabilityComponent<?> var4, boolean var5);

    void copy(CapabilityComponent<?> oldCapability, CapabilityComponent<?> newCapability) {
        newCapability.read(oldCapability.toCompoundTag());
    }
}

