/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class RecipeProvider
implements DataProvider {
    public final PackOutput.PathProvider recipePathProvider;
    public final PackOutput.PathProvider advancementPathProvider;
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (itemLike, itemLike2) -> RecipeProvider.buttonBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.CHISELED, (itemLike, itemLike2) -> RecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.CUT, (itemLike, itemLike2) -> RecipeProvider.cutBuilder(RecipeCategory.BUILDING_BLOCKS, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.DOOR, (itemLike, itemLike2) -> RecipeProvider.doorBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (itemLike, itemLike2) -> RecipeProvider.fenceBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.FENCE, (itemLike, itemLike2) -> RecipeProvider.fenceBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (itemLike, itemLike2) -> RecipeProvider.fenceGateBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.FENCE_GATE, (itemLike, itemLike2) -> RecipeProvider.fenceGateBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.SIGN, (itemLike, itemLike2) -> RecipeProvider.signBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.SLAB, (itemLike, itemLike2) -> RecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.STAIRS, (itemLike, itemLike2) -> RecipeProvider.stairBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (itemLike, itemLike2) -> RecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.POLISHED, (itemLike, itemLike2) -> RecipeProvider.polishedBuilder(RecipeCategory.BUILDING_BLOCKS, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.TRAPDOOR, (itemLike, itemLike2) -> RecipeProvider.trapdoorBuilder(itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).put((Object)BlockFamily.Variant.WALL, (itemLike, itemLike2) -> RecipeProvider.wallBuilder(RecipeCategory.DECORATIONS, itemLike, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}))).build();

    public RecipeProvider(PackOutput output) {
        this.recipePathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    public CompletableFuture<?> m_213708_(final CachedOutput output) {
        final HashSet set = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.buildRecipes(new RecipeOutput(){

            public void m_292927_(ResourceLocation location, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
                if (!set.add(location)) {
                    throw new IllegalStateException("Duplicate recipe " + location);
                }
                list.add(DataProvider.m_293028_((CachedOutput)output, (Codec)Recipe.f_302387_, recipe, (Path)RecipeProvider.this.recipePathProvider.m_245731_(location)));
                if (advancement != null) {
                    list.add(DataProvider.m_293028_((CachedOutput)output, (Codec)Advancement.f_303179_, (Object)advancement.f_290952_(), (Path)RecipeProvider.this.advancementPathProvider.m_245731_(advancement.f_291758_())));
                }
            }

            public Advancement.Builder m_293552_() {
                return Advancement.Builder.m_285878_().m_138396_(RecipeBuilder.f_236353_);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<?> buildAdvancement(CachedOutput output, AdvancementHolder advancementBuilder) {
        return DataProvider.m_293028_((CachedOutput)output, (Codec)Advancement.f_303179_, (Object)advancementBuilder.f_290952_(), (Path)this.advancementPathProvider.m_245731_(advancementBuilder.f_291758_()));
    }

    public abstract void buildRecipes(RecipeOutput var1);

    public static void generateForEnabledBlockFamilies(RecipeOutput recipeOutput, FeatureFlagSet enabledFeatures) {
        BlockFamilies.m_175934_().filter(BlockFamily::m_245288_).forEach(blockFamily -> RecipeProvider.generateRecipes(recipeOutput, blockFamily, enabledFeatures));
    }

    public static void oneToOneConversionRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, @Nullable String group) {
        RecipeProvider.oneToOneConversionRecipe(recipeOutput, result, ingredient, group, 1);
    }

    public static void oneToOneConversionRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, @Nullable String group, int resultCount) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)resultCount).m_126209_(ingredient).m_126145_(group).m_126132_(RecipeProvider.getHasName(ingredient), RecipeProvider.has(ingredient)).m_176500_(recipeOutput, RecipeProvider.getConversionRecipeName(result, ingredient));
    }

    public static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        RecipeProvider.oreCooking(recipeOutput, RecipeSerializer.f_44091_, SmeltingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
    }

    public static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        RecipeProvider.oreCooking(recipeOutput, RecipeSerializer.f_44092_, BlastingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_blasting");
    }

    public static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemLike : ingredients) {
            SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).m_126145_(group).m_126132_(RecipeProvider.getHasName(itemLike), RecipeProvider.has(itemLike)).m_176500_(recipeOutput, RecipeProvider.getItemName(result) + suffix + "_" + RecipeProvider.getItemName(itemLike));
        }
    }

    public static void netheriteSmithing(RecipeOutput recipeOutput, Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (RecipeCategory)category, (Item)resultItem).m_266439_("has_netherite_ingot", RecipeProvider.has((ItemLike)Items.f_42418_)).m_266260_(recipeOutput, RecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    public static void trimSmithing(RecipeOutput recipeOutput, Item ingredientItem, ResourceLocation location) {
        SmithingTrimRecipeBuilder.m_266182_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_265942_), (Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_265843_), (RecipeCategory)RecipeCategory.MISC).m_266331_("has_smithing_trim_template", RecipeProvider.has((ItemLike)ingredientItem)).m_266403_(recipeOutput, location);
    }

    public static void twoByTwoPacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)packed, (int)1).m_126127_(Character.valueOf('#'), unpacked).m_126130_("##").m_126130_("##").m_126132_(RecipeProvider.getHasName(unpacked), RecipeProvider.has(unpacked)).m_176498_(recipeOutput);
    }

    public static void threeByThreePacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked, String criterionName) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)packed).m_126211_(unpacked, 9).m_126132_(criterionName, RecipeProvider.has(unpacked)).m_176498_(recipeOutput);
    }

    public static void threeByThreePacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        RecipeProvider.threeByThreePacker(recipeOutput, category, packed, unpacked, RecipeProvider.getHasName(unpacked));
    }

    public static void planksFromLog(RecipeOutput recipeOutput, ItemLike planks, TagKey<Item> logs, int resultCount) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)resultCount).m_206419_(logs).m_126145_("planks").m_126132_("has_log", RecipeProvider.has(logs)).m_176498_(recipeOutput);
    }

    public static void planksFromLogs(RecipeOutput recipeOutput, ItemLike planks, TagKey<Item> logs, int result) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)result).m_206419_(logs).m_126145_("planks").m_126132_("has_logs", RecipeProvider.has(logs)).m_176498_(recipeOutput);
    }

    public static void woodFromLogs(RecipeOutput recipeOutput, ItemLike wood, ItemLike log) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)3).m_126127_(Character.valueOf('#'), log).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", RecipeProvider.has(log)).m_176498_(recipeOutput);
    }

    public static void woodenBoat(RecipeOutput recipeOutput, ItemLike boat, ItemLike material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat).m_126127_(Character.valueOf('#'), material).m_126130_("# #").m_126130_("###").m_126145_("boat").m_126132_("in_water", RecipeProvider.insideOf(Blocks.f_49990_)).m_176498_(recipeOutput);
    }

    public static void chestBoat(RecipeOutput recipeOutput, ItemLike boat, ItemLike material) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat).m_126209_((ItemLike)Blocks.f_50087_).m_126209_(material).m_126145_("chest_boat").m_126132_("has_boat", RecipeProvider.has((TagKey<Item>)ItemTags.f_13155_)).m_176498_(recipeOutput);
    }

    public static RecipeBuilder buttonBuilder(ItemLike button, Ingredient material) {
        return ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button).m_126184_(material);
    }

    public static RecipeBuilder doorBuilder(ItemLike door, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)door, (int)3).m_126124_(Character.valueOf('#'), material).m_126130_("##").m_126130_("##").m_126130_("##");
    }

    public static RecipeBuilder fenceBuilder(ItemLike fence, Ingredient material) {
        int i = fence == Blocks.f_50198_ ? 6 : 3;
        Item item = fence == Blocks.f_50198_ ? Items.f_42691_ : Items.f_42398_;
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)i).m_126124_(Character.valueOf('W'), material).m_126127_(Character.valueOf('#'), (ItemLike)item).m_126130_("W#W").m_126130_("W#W");
    }

    public static RecipeBuilder fenceGateBuilder(ItemLike fenceGate, Ingredient material) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('W'), material).m_126130_("#W#").m_126130_("#W#");
    }

    public static void pressurePlate(RecipeOutput recipeOutput, ItemLike pressurePlate, ItemLike material) {
        RecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, pressurePlate, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static RecipeBuilder pressurePlateBuilder(RecipeCategory category, ItemLike pressurePlate, Ingredient material) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)pressurePlate).m_126124_(Character.valueOf('#'), material).m_126130_("##");
    }

    public static void slab(RecipeOutput recipeOutput, RecipeCategory category, ItemLike slab, ItemLike material) {
        RecipeProvider.slabBuilder(category, slab, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static RecipeBuilder slabBuilder(RecipeCategory category, ItemLike slab, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)slab, (int)6).m_126124_(Character.valueOf('#'), material).m_126130_("###");
    }

    public static RecipeBuilder stairBuilder(ItemLike stairs, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).m_126124_(Character.valueOf('#'), material).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    public static RecipeBuilder trapdoorBuilder(ItemLike trapdoor, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trapdoor, (int)2).m_126124_(Character.valueOf('#'), material).m_126130_("###").m_126130_("###");
    }

    public static RecipeBuilder signBuilder(ItemLike sign, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)3).m_126145_("sign").m_126124_(Character.valueOf('#'), material).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" X ");
    }

    public static void hangingSign(RecipeOutput recipeOutput, ItemLike sign, ItemLike material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)6).m_126145_("hanging_sign").m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42026_).m_126130_("X X").m_126130_("###").m_126130_("###").m_126132_("has_stripped_logs", RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static void colorBlockWithDye(RecipeOutput recipeOutput, List<Item> dyes, List<Item> dyeableItems, String group) {
        for (int i = 0; i < dyes.size(); ++i) {
            Item item = dyes.get(i);
            Item item2 = dyeableItems.get(i);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item2).m_126209_((ItemLike)item).m_126184_(Ingredient.m_43921_(dyeableItems.stream().filter(item2x -> !item2x.equals(item2)).map(ItemStack::new))).m_126145_(group).m_126132_("has_needed_dye", RecipeProvider.has((ItemLike)item)).m_176500_(recipeOutput, "dye_" + RecipeProvider.getItemName((ItemLike)item2));
        }
    }

    public static void carpet(RecipeOutput recipeOutput, ItemLike carpet, ItemLike material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)carpet, (int)3).m_126127_(Character.valueOf('#'), material).m_126130_("##").m_126145_("carpet").m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static void bedFromPlanksAndWool(RecipeOutput recipeOutput, ItemLike bed, ItemLike wool) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)bed).m_126127_(Character.valueOf('#'), wool).m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126130_("###").m_126130_("XXX").m_126145_("bed").m_126132_(RecipeProvider.getHasName(wool), RecipeProvider.has(wool)).m_176498_(recipeOutput);
    }

    public static void banner(RecipeOutput recipeOutput, ItemLike banner, ItemLike material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)banner).m_126127_(Character.valueOf('#'), material).m_126127_(Character.valueOf('|'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" | ").m_126145_("banner").m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static void stainedGlassFromGlassAndDye(RecipeOutput recipeOutput, ItemLike stainedGlass, ItemLike dye) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stainedGlass, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50058_).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_glass").m_126132_("has_glass", RecipeProvider.has((ItemLike)Blocks.f_50058_)).m_176498_(recipeOutput);
    }

    public static void stainedGlassPaneFromStainedGlass(RecipeOutput recipeOutput, ItemLike stainedGlassPane, ItemLike stainedGlass) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stainedGlassPane, (int)16).m_126127_(Character.valueOf('#'), stainedGlass).m_126130_("###").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass", RecipeProvider.has(stainedGlass)).m_176498_(recipeOutput);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(RecipeOutput recipeOutput, ItemLike stainedGlassPane, ItemLike dye) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stainedGlassPane, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50185_).m_126127_(Character.valueOf('$'), dye).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass_pane", RecipeProvider.has((ItemLike)Blocks.f_50185_)).m_126132_(RecipeProvider.getHasName(dye), RecipeProvider.has(dye)).m_176500_(recipeOutput, RecipeProvider.getConversionRecipeName(stainedGlassPane, (ItemLike)Blocks.f_50185_));
    }

    public static void coloredTerracottaFromTerracottaAndDye(RecipeOutput recipeOutput, ItemLike terracotta, ItemLike dye) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)terracotta, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50352_).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_terracotta").m_126132_("has_terracotta", RecipeProvider.has((ItemLike)Blocks.f_50352_)).m_176498_(recipeOutput);
    }

    public static void concretePowder(RecipeOutput recipeOutput, ItemLike concretePowder, ItemLike dye) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concretePowder, (int)8).m_126209_(dye).m_126211_((ItemLike)Blocks.f_49992_, 4).m_126211_((ItemLike)Blocks.f_49994_, 4).m_126145_("concrete_powder").m_126132_("has_sand", RecipeProvider.has((ItemLike)Blocks.f_49992_)).m_126132_("has_gravel", RecipeProvider.has((ItemLike)Blocks.f_49994_)).m_176498_(recipeOutput);
    }

    public static void candle(RecipeOutput recipeOutput, ItemLike candle, ItemLike dye) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)candle).m_126209_((ItemLike)Blocks.f_152482_).m_126209_(dye).m_126145_("dyed_candle").m_126132_(RecipeProvider.getHasName(dye), RecipeProvider.has(dye)).m_176498_(recipeOutput);
    }

    public static void wall(RecipeOutput recipeOutput, RecipeCategory category, ItemLike wall, ItemLike material) {
        RecipeProvider.wallBuilder(category, wall, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static RecipeBuilder wallBuilder(RecipeCategory category, ItemLike wall, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)wall, (int)6).m_126124_(Character.valueOf('#'), material).m_126130_("###").m_126130_("###");
    }

    public static void polished(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        RecipeProvider.polishedBuilder(category, result, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static RecipeBuilder polishedBuilder(RecipeCategory category, ItemLike result, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result, (int)4).m_126124_(Character.valueOf('S'), material).m_126130_("SS").m_126130_("SS");
    }

    public static void cut(RecipeOutput recipeOutput, RecipeCategory category, ItemLike cutResult, ItemLike material) {
        RecipeProvider.cutBuilder(category, cutResult, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static ShapedRecipeBuilder cutBuilder(RecipeCategory category, ItemLike cutResult, Ingredient material) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)cutResult, (int)4).m_126124_(Character.valueOf('#'), material).m_126130_("##").m_126130_("##");
    }

    public static void chiseled(RecipeOutput recipeOutput, RecipeCategory category, ItemLike chiseledResult, ItemLike material) {
        RecipeProvider.chiseledBuilder(category, chiseledResult, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static void mosaicBuilder(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)result).m_126127_(Character.valueOf('#'), material).m_126130_("#").m_126130_("#").m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176498_(recipeOutput);
    }

    public static ShapedRecipeBuilder chiseledBuilder(RecipeCategory category, ItemLike chiseledResult, Ingredient material) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)chiseledResult).m_126124_(Character.valueOf('#'), material).m_126130_("#").m_126130_("#");
    }

    public static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        RecipeProvider.stonecutterResultFromBase(recipeOutput, category, result, material, 1);
    }

    public static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material, int resultCount) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)category, (ItemLike)result, (int)resultCount).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176500_(recipeOutput, RecipeProvider.getConversionRecipeName(result, material) + "_stonecutting");
    }

    public static void smeltingResultFromBase(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)200).m_126132_(RecipeProvider.getHasName(ingredient), RecipeProvider.has(ingredient)).m_176498_(recipeOutput);
    }

    public static void nineBlockStorageRecipes(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed) {
        RecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.getSimpleRecipeName(packed), null, RecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, String packedGroup) {
        RecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, packedName, packedGroup, RecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String unpackedName, String unpackedGroup) {
        RecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.getSimpleRecipeName(packed), null, unpackedName, unpackedGroup);
    }

    public static void nineBlockStorageRecipes(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, @Nullable String packedGroup, String unpackedName, @Nullable String unpackedGroup) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)unpackedCategory, (ItemLike)unpacked, (int)9).m_126209_(packed).m_126145_(unpackedGroup).m_126132_(RecipeProvider.getHasName(packed), RecipeProvider.has(packed)).m_126140_(recipeOutput, new ResourceLocation(unpackedName));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)packedCategory, (ItemLike)packed).m_126127_(Character.valueOf('#'), unpacked).m_126130_("###").m_126130_("###").m_126130_("###").m_126145_(packedGroup).m_126132_(RecipeProvider.getHasName(unpacked), RecipeProvider.has(unpacked)).m_126140_(recipeOutput, new ResourceLocation(packedName));
    }

    public static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, TagKey<Item> baseMaterial) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42415_).m_206416_(Character.valueOf('C'), baseMaterial).m_126127_(Character.valueOf('S'), template).m_126130_("#S#").m_126130_("#C#").m_126130_("###").m_126132_(RecipeProvider.getHasName(template), RecipeProvider.has(template)).m_176498_(recipeOutput);
    }

    public static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, ItemLike baseItem) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('C'), baseItem).m_126127_(Character.valueOf('S'), template).m_126130_("#S#").m_126130_("#C#").m_126130_("###").m_126132_(RecipeProvider.getHasName(template), RecipeProvider.has(template)).m_176498_(recipeOutput);
    }

    public static <T extends AbstractCookingRecipe> void cookRecipes(RecipeOutput recipeOutput, String cookingMethod, RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime) {
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42579_, (ItemLike)Items.f_42580_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42581_, (ItemLike)Items.f_42582_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42526_, (ItemLike)Items.f_42530_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_41910_, (ItemLike)Items.f_42576_, 0.1f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42527_, (ItemLike)Items.f_42531_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42658_, (ItemLike)Items.f_42659_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42485_, (ItemLike)Items.f_42486_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42620_, (ItemLike)Items.f_42674_, 0.35f);
        RecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.f_42697_, (ItemLike)Items.f_42698_, 0.35f);
    }

    public static <T extends AbstractCookingRecipe> void simpleCookingRecipe(RecipeOutput recipeOutput, String cookingMethod, RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime, ItemLike material, ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, cookingSerializer, recipeFactory).m_126132_(RecipeProvider.getHasName(material), RecipeProvider.has(material)).m_176500_(recipeOutput, RecipeProvider.getItemName(result) + "_from_" + cookingMethod);
    }

    public static void waxRecipes(RecipeOutput recipeOutput, FeatureFlagSet requiredFeatures) {
        ((BiMap)HoneycombItem.f_150863_.get()).forEach((block, block2) -> {
            if (block2.m_245183_().m_247715_(requiredFeatures)) {
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block2).m_126209_((ItemLike)block).m_126209_((ItemLike)Items.f_42784_).m_126145_(RecipeProvider.getItemName((ItemLike)block2)).m_126132_(RecipeProvider.getHasName((ItemLike)block), RecipeProvider.has((ItemLike)block)).m_176500_(recipeOutput, RecipeProvider.getConversionRecipeName((ItemLike)block2, (ItemLike)Items.f_42784_));
            }
        });
    }

    public static void grate(RecipeOutput recipeOutput, Block grateBlock, Block material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)grateBlock, (int)4).m_126127_(Character.valueOf('M'), (ItemLike)material).m_126130_(" M ").m_126130_("M M").m_126130_(" M ").m_126132_(RecipeProvider.getHasName((ItemLike)material), RecipeProvider.has((ItemLike)material)).m_176498_(recipeOutput);
    }

    public static void copperBulb(RecipeOutput recipeOutput, Block bulbBlock, Block material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)bulbBlock, (int)4).m_126127_(Character.valueOf('C'), (ItemLike)material).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_126130_(" C ").m_126130_("CBC").m_126130_(" R ").m_126132_(RecipeProvider.getHasName((ItemLike)material), RecipeProvider.has((ItemLike)material)).m_176498_(recipeOutput);
    }

    public static void generateRecipes(RecipeOutput recipeOutput, BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        blockFamily.m_175954_().forEach((variant, block) -> {
            if (block.m_245183_().m_247715_(requiredFeatures)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> biFunction = SHAPE_BUILDERS.get(variant);
                Block itemLike = RecipeProvider.getBaseBlock(blockFamily, variant);
                if (biFunction != null) {
                    RecipeBuilder recipeBuilder = biFunction.apply((ItemLike)block, (ItemLike)itemLike);
                    blockFamily.m_175957_().ifPresent(string -> recipeBuilder.m_126145_(string + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.m_294338_())));
                    recipeBuilder.m_126132_(blockFamily.m_175958_().orElseGet(() -> RecipeProvider.lambda$generateRecipes$20((ItemLike)itemLike)), RecipeProvider.has((ItemLike)itemLike));
                    recipeBuilder.m_176498_(recipeOutput);
                }
                if (variant == BlockFamily.Variant.CRACKED) {
                    RecipeProvider.smeltingResultFromBase(recipeOutput, (ItemLike)block, (ItemLike)itemLike);
                }
            }
        });
    }

    public static Block getBaseBlock(BlockFamily family, BlockFamily.Variant variant) {
        if (variant == BlockFamily.Variant.CHISELED) {
            if (!family.m_175954_().containsKey(BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.m_175952_(BlockFamily.Variant.SLAB);
        }
        return family.m_175951_();
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return CriteriaTriggers.f_10570_.m_292665_((CriterionTriggerInstance)new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(block.m_204297_()), Optional.empty()));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints count, ItemLike item) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_151443_(count));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike itemLike) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tag));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... items) {
        return RecipeProvider.inventoryTrigger((ItemPredicate[])Arrays.stream(items).map(ItemPredicate.Builder::m_45077_).toArray(ItemPredicate[]::new));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.f_10571_.m_292665_((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.f_303621_, List.of(predicates)));
    }

    public static String getHasName(ItemLike itemLike) {
        return "has_" + RecipeProvider.getItemName(itemLike);
    }

    public static String getItemName(ItemLike itemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)itemLike.m_5456_()).m_135815_();
    }

    public static String getSimpleRecipeName(ItemLike itemLike) {
        return RecipeProvider.getItemName(itemLike);
    }

    public static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return RecipeProvider.getItemName(result) + "_from_" + RecipeProvider.getItemName(ingredient);
    }

    public static String getSmeltingRecipeName(ItemLike itemLike) {
        return RecipeProvider.getItemName(itemLike) + "_from_smelting";
    }

    public static String getBlastingRecipeName(ItemLike itemLike) {
        return RecipeProvider.getItemName(itemLike) + "_from_blasting";
    }

    public String m_6055_() {
        return "Recipes";
    }

    private static /* synthetic */ String lambda$generateRecipes$20(ItemLike itemLike) {
        return RecipeProvider.getHasName(itemLike);
    }
}

