/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV3 {
    public static Builder builder(String modId) {
        return NetworkHandlerV3.builder(new ResourceLocation(modId, "main"));
    }

    public static Builder builder(ResourceLocation channelName) {
        return ModContext.get(channelName.m_135827_()).getNetworkHandlerV3(channelName);
    }

    public <T extends Record> Packet<ClientCommonPacketListener> toClientboundPacket(T var1);

    public <T extends Record> Packet<ServerCommonPacketListener> toServerboundPacket(T var1);

    default public <T extends Record> void sendToServer(T message) {
        ClientPacketListener clientPacketListener = Proxy.INSTANCE.getClientPacketListener();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        clientPacketListener.m_295327_(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendTo(ServerPlayer player, T message) {
        Objects.requireNonNull(player, "player is null");
        player.f_8906_.m_141995_(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, T message) {
        this.sendToAll(server, null, message);
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, @Nullable ServerPlayer exclude, T message) {
        Objects.requireNonNull(server, "server is null");
        this.sendToAll(server.m_6846_().m_11314_(), exclude, message);
    }

    default public <T extends Record> void sendToAll(Collection<ServerPlayer> playerList, @Nullable ServerPlayer exclude, T message) {
        Objects.requireNonNull(playerList, "player list is null");
        for (ServerPlayer player : playerList) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAll(ServerLevel level, T message) {
        Objects.requireNonNull(level, "level is null");
        for (ServerPlayer player : level.m_6907_()) {
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAllNear(Vec3i pos, ServerLevel level, T message) {
        Objects.requireNonNull(pos, "pos is null");
        this.sendToAllNear(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), level, message);
    }

    default public <T extends Record> void sendToAllNear(double posX, double posY, double posZ, ServerLevel level, T message) {
        this.sendToAllNear(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNear(@Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, ServerLevel level, T message) {
        Objects.requireNonNull(level, "level is null");
        level.m_7654_().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(BlockEntity blockEntity, T message) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.m_58904_();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.f_46443_ ? 1 : 0) != 0, (Object)"block entity level is client level");
        this.sendToAllNear((Vec3i)blockEntity.m_58899_(), (ServerLevel)level, message);
    }

    default public <T extends Record> void sendToAllTracking(LevelChunk chunk, T message) {
        Objects.requireNonNull(chunk, "chunk is null");
        Preconditions.checkState((!chunk.m_62953_().f_46443_ ? 1 : 0) != 0, (Object)"chunk level is client level");
        this.sendToAllTracking((ServerLevel)chunk.m_62953_(), chunk.m_7697_(), message);
    }

    default public <T extends Record> void sendToAllTracking(ServerLevel level, ChunkPos chunkPos, T message) {
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        List players = level.m_7726_().f_8325_.m_183262_(chunkPos, false);
        this.sendToAll(players, null, message);
    }

    default public <T extends Record> void sendToAllTracking(Entity entity, T message, boolean includeSelf) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.m_20193_().f_46443_ ? 1 : 0) != 0, (Object)"entity level is client level");
        ServerChunkCache chunkSource = ((ServerLevel)entity.m_20193_()).m_7726_();
        if (includeSelf) {
            chunkSource.m_8394_(entity, this.toClientboundPacket(message));
        } else {
            chunkSource.m_8445_(entity, this.toClientboundPacket(message));
        }
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    Buildable {
        default public <T> Builder registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder optional();
    }
}

