/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.api.core.v1;

import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;

public final class ForgeModContainerHelper {
    private ForgeModContainerHelper() {
    }

    public static IEventBus getActiveModEventBus() {
        return ForgeModContainerHelper.getOptionalActiveModEventBus().orElseThrow(() -> new NullPointerException("active event bus is null"));
    }

    public static Optional<IEventBus> getOptionalActiveModEventBus() {
        return Optional.ofNullable(FMLJavaModLoadingContext.get()).map(FMLJavaModLoadingContext::getModEventBus);
    }

    public static IEventBus getModEventBus(String modId) {
        return ForgeModContainerHelper.getOptionalModEventBus(modId).orElseThrow(() -> new NullPointerException("event bus for %s is null".formatted(modId)));
    }

    public static Optional<IEventBus> getOptionalModEventBus(String modId) {
        return ForgeModContainerHelper.getOptionalModContainer(modId).filter(FMLModContainer.class::isInstance).map(FMLModContainer.class::cast).map(FMLModContainer::getEventBus);
    }

    public static ModContainer getModContainer(String modId) {
        return ForgeModContainerHelper.getOptionalModContainer(modId).orElseThrow(() -> new NullPointerException("mod container for %s is null".formatted(modId)));
    }

    public static Optional<? extends ModContainer> getOptionalModContainer(String modId) {
        ModList modList = ModList.get();
        Objects.requireNonNull(modList, "mod list is null");
        return modList.getModContainerById(modId);
    }
}

