/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.capability.v3.data.BlockEntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelChunkCapabilityKey;
import fuzs.puzzleslib.forge.api.core.v1.ForgeModContainerHelper;
import fuzs.puzzleslib.forge.impl.capability.data.CapabilityAdapter;
import fuzs.puzzleslib.forge.impl.capability.data.ForgeBlockEntityCapabilityKey;
import fuzs.puzzleslib.forge.impl.capability.data.ForgeCapabilityKey;
import fuzs.puzzleslib.forge.impl.capability.data.ForgeEntityCapabilityKey;
import fuzs.puzzleslib.forge.impl.capability.data.ForgeLevelCapabilityKey;
import fuzs.puzzleslib.forge.impl.capability.data.ForgeLevelChunkCapabilityKey;
import fuzs.puzzleslib.impl.capability.GlobalCapabilityRegister;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public final class ForgeCapabilityController
implements CapabilityController {
    private final Multimap<Class<?>, CapabilityData<?, ?>> capabilityData = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);
    private final String modId;

    public ForgeCapabilityController(String modId) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.modId = modId;
        ForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(this::onRegisterCapabilities));
    }

    @Override
    public <T extends Entity, C extends CapabilityComponent<T>> EntityCapabilityKey.Mutable<T, C> registerEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> entityType) {
        return (EntityCapabilityKey.Mutable)this.registerCapability(Entity.class, identifier, capabilityType, capabilityFactory, entityType::isInstance, ForgeEntityCapabilityKey::new);
    }

    @Override
    public <T extends BlockEntity, C extends CapabilityComponent<T>> BlockEntityCapabilityKey<T, C> registerBlockEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> blockEntityType) {
        return (BlockEntityCapabilityKey)this.registerCapability(BlockEntity.class, identifier, capabilityType, capabilityFactory, blockEntityType::isInstance, ForgeBlockEntityCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<LevelChunk>> LevelChunkCapabilityKey<C> registerLevelChunkCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return (LevelChunkCapabilityKey)this.registerCapability(LevelChunk.class, identifier, capabilityType, capabilityFactory, ForgeLevelChunkCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<Level>> LevelCapabilityKey<C> registerLevelCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return (LevelCapabilityKey)this.registerCapability(Level.class, identifier, capabilityType, capabilityFactory, ForgeLevelCapabilityKey::new);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ICapabilityProvider> holderType, String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, ForgeCapabilityKey.ForgeCapabilityKeyFactory<T, C, K> capabilityKeyFactory) {
        return this.registerCapability(holderType, identifier, capabilityType, capabilityFactory, holderType::isInstance, capabilityKeyFactory);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ICapabilityProvider> holderType, String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Predicate<Object> filter, ForgeCapabilityKey.ForgeCapabilityKeyFactory<T, C, K> capabilityKeyFactory) {
        GlobalCapabilityRegister.testHolderType(holderType);
        ResourceLocation capabilityName = new ResourceLocation(this.modId, identifier);
        CapabilityData capabilityData = new CapabilityData(capabilityName, capabilityType, filter);
        this.capabilityData.put(holderType, capabilityData);
        Object[] capabilityKey = new Object[1];
        ForgeCapabilityKey.CapabilityTokenFactory tokenFactory = token -> {
            Capability capability = CapabilityManager.get((CapabilityToken)token);
            capabilityData.setFactory(arg_0 -> ForgeCapabilityController.lambda$registerCapability$1((Supplier)capabilityFactory, capabilityKey, capability, arg_0));
            return capability;
        };
        capabilityKey[0] = capabilityKeyFactory.apply(capabilityName, tokenFactory);
        return (K)((CapabilityKey)capabilityKey[0]);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent evt) {
        for (CapabilityData data : this.capabilityData.values()) {
            evt.register(data.type());
        }
    }

    @SubscribeEvent
    public <T> void onAttachCapabilities(AttachCapabilitiesEvent<?> evt) {
        Class holderType = (Class)evt.getGenericType();
        for (CapabilityData data : this.capabilityData.get((Object)holderType)) {
            if (!data.test(evt.getObject())) continue;
            evt.addCapability(data.identifier(), data.apply(evt.getObject()));
        }
    }

    private static /* synthetic */ CapabilityAdapter lambda$registerCapability$1(Supplier capabilityFactory, Object[] capabilityKey, Capability capability, Object t) {
        CapabilityComponent capabilityComponent = (CapabilityComponent)capabilityFactory.get();
        Objects.requireNonNull(capabilityComponent, "capability component is null");
        capabilityComponent.initialize((CapabilityKey)capabilityKey[0], t);
        return new CapabilityAdapter(capability, capabilityComponent);
    }

    private static final class CapabilityData<T, C extends CapabilityComponent<T>> {
        private final ResourceLocation identifier;
        private final Class<C> type;
        private final Predicate<Object> filter;
        @Nullable
        private Function<T, CapabilityAdapter<T, C>> factory;

        private CapabilityData(ResourceLocation identifier, Class<C> type, Predicate<Object> filter) {
            this.identifier = identifier;
            this.type = type;
            this.filter = filter;
        }

        public ResourceLocation identifier() {
            return this.identifier;
        }

        public Class<C> type() {
            return this.type;
        }

        public void setFactory(Function<T, CapabilityAdapter<T, C>> factory) {
            this.factory = factory;
        }

        public CapabilityAdapter<T, C> apply(T t) {
            Objects.requireNonNull(this.factory, "factory is null");
            return this.factory.apply(t);
        }

        public boolean test(@Nullable Object o) {
            return o != null && this.filter.test(o);
        }
    }
}

