/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.client.core;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.particle.v1.ClientParticleTypes;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.forge.api.core.v1.ForgeModContainerHelper;
import fuzs.puzzleslib.forge.impl.client.core.context.AdditionalModelsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.BlockColorProvidersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.BlockEntityRenderersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.BuiltinModelItemRendererContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ClientTooltipComponentsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.CoreShadersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.EntityRenderersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.EntitySpectatorShaderContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ItemColorProvidersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ItemDecorationContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ItemModelPropertiesContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.KeyMappingsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.LayerDefinitionsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.LivingEntityRenderLayersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.MenuScreensContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ParticleProvidersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.ResourcePackSourcesContextForgeImpl;
import fuzs.puzzleslib.forge.impl.client.core.context.SkullRenderersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.AddReloadListenersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextImpl;
import fuzs.puzzleslib.impl.client.particle.ClientParticleTypesImpl;
import fuzs.puzzleslib.impl.client.particle.ClientParticleTypesManager;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class ForgeClientModConstructor {
    private ForgeClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> {
            ForgeClientModConstructor.registerModHandlers(constructor, modId, eventBus, availableFlags, flagsToHandle);
            constructor.onConstructMod();
        });
    }

    private static void registerModHandlers(ClientModConstructor constructor, String modId, IEventBus eventBus, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ArrayList dynamicRenderers = Lists.newArrayList();
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onClientSetup();
            constructor.onRegisterMenuScreens(new MenuScreensContextForgeImpl());
            constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextForgeImpl());
            constructor.onRegisterBuiltinModelItemRenderers(new BuiltinModelItemRendererContextForgeImpl(modId, dynamicRenderers));
            constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextImpl());
            constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextImpl());
        }));
        eventBus.addListener(evt -> {
            constructor.onRegisterEntityRenderers(new EntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1)));
            constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1)));
        });
        eventBus.addListener(evt -> constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextForgeImpl((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterParticleProviders(new ParticleProvidersContextForgeImpl((RegisterParticleProvidersEvent)evt)));
        eventBus.addListener(evt -> constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterAdditionalModels(new AdditionalModelsContextForgeImpl(arg_0 -> ((ModelEvent.RegisterAdditional)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterItemDecorations(new ItemDecorationContextForgeImpl((arg_0, arg_1) -> ((RegisterItemDecorationsEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterEntitySpectatorShaders(new EntitySpectatorShaderContextForgeImpl((arg_0, arg_1) -> ((RegisterEntitySpectatorShadersEvent)evt).register(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterSkullRenderers(new SkullRenderersContextForgeImpl(evt.getEntityModelSet(), (arg_0, arg_1) -> ((EntityRenderersEvent.CreateSkullModels)evt).registerSkullModel(arg_0, arg_1))));
        eventBus.addListener(evt -> {
            constructor.onRegisterResourcePackReloadListeners(new AddReloadListenersContextForgeImpl(modId, arg_0 -> ((RegisterClientReloadListenersEvent)evt).registerReloadListener(arg_0)));
            if (availableFlags.contains((Object)ContentRegistrationFlags.DYNAMIC_RENDERERS)) {
                evt.registerReloadListener(ForwardingReloadListenerHelper.fromResourceManagerReloadListeners(new ResourceLocation(modId, "built_in_model_item_renderers"), dynamicRenderers));
            }
            if (flagsToHandle.contains((Object)ContentRegistrationFlags.CLIENT_PARTICLE_TYPES)) {
                ClientParticleTypesManager particleTypesManager = ((ClientParticleTypesImpl)ClientParticleTypes.INSTANCE).getParticleTypesManager(modId);
                evt.registerReloadListener(ForwardingReloadListenerHelper.fromReloadListener(new ResourceLocation(modId, "client_particle_types"), particleTypesManager));
            }
        });
        eventBus.addListener(evt -> constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextForgeImpl((EntityRenderersEvent.AddLayers)evt)));
        eventBus.addListener(evt -> constructor.onRegisterKeyMappings(new KeyMappingsContextForgeImpl(arg_0 -> ((RegisterKeyMappingsEvent)evt).register(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextForgeImpl((x$0, xva$1) -> evt.register(x$0, new Block[]{xva$1}), evt.getBlockColors())));
        eventBus.addListener(evt -> constructor.onRegisterItemColorProviders(new ItemColorProvidersContextForgeImpl((x$0, xva$1) -> evt.register(x$0, new ItemLike[]{xva$1}), evt.getItemColors())));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                constructor.onAddResourcePackFinders(new ResourcePackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
            }
        });
        eventBus.addListener(evt -> constructor.onRegisterCoreShaders(new CoreShadersContextForgeImpl((arg_0, arg_1) -> ((RegisterShadersEvent)evt).registerShader(arg_0, arg_1), evt.getResourceProvider())));
    }
}

