/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.core;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public record ForgeModContainer(IModInfo metadata) implements ModContainer
{
    @Override
    public String getModId() {
        return this.metadata.getModId();
    }

    @Override
    public String getDisplayName() {
        return this.metadata.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    public String getVersion() {
        return MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.metadata.getVersion());
    }

    @Override
    public Collection<String> getLicenses() {
        return List.of(this.metadata.getOwningFile().getLicense());
    }

    @Override
    public Collection<String> getAuthors() {
        return this.getConfigElement("authors");
    }

    @Override
    public Collection<String> getCredits() {
        return this.getConfigElement("credits");
    }

    private List<String> getConfigElement(String configKey) {
        return this.metadata.getConfig().getConfigElement(new String[]{configKey}).map(authors -> {
            if (authors instanceof Collection) {
                Collection collection = (Collection)authors;
                return collection.stream().map(Object::toString).toList();
            }
            return List.of(authors.toString());
        }).orElseGet(List::of);
    }

    @Override
    public Map<String, String> getContactTypes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.metadata.getConfig().getConfigElement(new String[]{"displayURL"}).or(() -> this.metadata.getModURL().map(URL::toString)).ifPresent(s -> builder.put((Object)"homepage", s));
        IModFileInfo iModFileInfo = this.metadata.getOwningFile();
        if (iModFileInfo instanceof ModFileInfo) {
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            Optional.ofNullable(modFileInfo.getIssueURL()).map(URL::toString).ifPresent(s -> builder.put((Object)"issues", s));
        }
        return builder.build();
    }

    @Override
    public Optional<Path> findResource(String ... path) {
        return Optional.of(this.metadata.getOwningFile().getFile().findResource(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }
}

