/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.init;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.init.v3.registry.ExtendedMenuSupplier;
import fuzs.puzzleslib.forge.api.core.v1.ForgeModContainerHelper;
import fuzs.puzzleslib.impl.init.LazyHolder;
import fuzs.puzzleslib.impl.init.RegistryManagerImpl;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public final class ForgeRegistryManager
extends RegistryManagerImpl {
    @Nullable
    private final IEventBus eventBus;
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registers = Maps.newIdentityHashMap();

    public ForgeRegistryManager(String modId) {
        super(modId);
        this.eventBus = ForgeModContainerHelper.getOptionalModEventBus(modId).orElse(null);
    }

    @Override
    protected <T> Holder.Reference<T> getHolderReference(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        DeferredRegister registrar = this.registers.computeIfAbsent(registryKey, $ -> {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)this.modId);
            Objects.requireNonNull(this.eventBus, "mod event bus for %s is null".formatted(this.modId));
            deferredRegister.register(this.eventBus);
            return deferredRegister;
        });
        RegistryObject registryObject = registrar.register(path, () -> {
            Object value = supplier.get();
            Objects.requireNonNull(value, "value is null");
            return value;
        });
        return new LazyHolder(registryKey, registryObject.getKey(), () -> (Holder)registryObject.getHolder().orElseThrow(() -> new IllegalStateException("Missing key in " + registryKey + ": " + registryObject.getKey())));
    }

    @Override
    public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor, Item.Properties itemProperties) {
        return this.registerItem(((ResourceKey)entityTypeReference.m_203543_().orElseThrow()).m_135782_().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityTypeReference, backgroundColor, highlightColor, itemProperties));
    }

    @Override
    public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerExtendedMenuType(String path, Supplier<ExtendedMenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> IForgeMenuType.create(((ExtendedMenuSupplier)entry.get())::create));
    }

    @Override
    public Holder.Reference<PoiType> registerPoiType(String path, Supplier<Set<BlockState>> matchingStates, int maxTickets, int validRange) {
        return this.register(Registries.f_256805_, path, () -> new PoiType((Set)matchingStates.get(), maxTickets, validRange));
    }
}

