/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.item.crafting;

import fuzs.puzzleslib.api.item.v2.crafting.CombinedIngredients;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ingredients.CompoundIngredient;
import net.minecraftforge.common.crafting.ingredients.DifferenceIngredient;
import net.minecraftforge.common.crafting.ingredients.IntersectionIngredient;
import net.minecraftforge.common.crafting.ingredients.PartialNBTIngredient;
import net.minecraftforge.common.crafting.ingredients.StrictNBTIngredient;

public final class ForgeCombinedIngredients
implements CombinedIngredients {
    @Override
    public Ingredient all(Ingredient ... ingredients) {
        Objects.requireNonNull(ingredients, "ingredients is null");
        for (Ingredient ingredient : ingredients) {
            Objects.requireNonNull(ingredient, "ingredient is null");
        }
        return IntersectionIngredient.of((Ingredient[])ingredients);
    }

    @Override
    public Ingredient any(Ingredient ... ingredients) {
        Objects.requireNonNull(ingredients, "ingredients is null");
        for (Ingredient ingredient : ingredients) {
            Objects.requireNonNull(ingredient, "ingredient is null");
        }
        return CompoundIngredient.of((Ingredient[])ingredients);
    }

    @Override
    public Ingredient difference(Ingredient ingredient, Ingredient subtracted) {
        Objects.requireNonNull(ingredient, "ingredient is null");
        Objects.requireNonNull(subtracted, "subtracted is null");
        return DifferenceIngredient.of((Ingredient)ingredient, (Ingredient)subtracted);
    }

    @Override
    public Ingredient nbt(ItemStack stack, boolean strict) {
        Objects.requireNonNull(stack, "stack is null");
        if (strict) {
            return StrictNBTIngredient.of((ItemStack)stack);
        }
        CompoundTag tag = stack.m_41783_();
        Objects.requireNonNull(tag, "tag is null");
        return PartialNBTIngredient.of((CompoundTag)tag, (ItemLike[])new ItemLike[]{stack.m_41720_()});
    }
}

