/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt;

import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.ModIngredientSerializersRegisterFactory;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class NBTIngredient
extends AbstractIngredient {
    @NotNull
    public static final String registry_name = "nbt";
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final MatchType matchType;

    public NBTIngredient(@NotNull ItemStack _stack, @NotNull MatchType _matchType) {
        super(Stream.of(new Ingredient.ItemValue(_stack)));
        this.stack = _stack;
        this.matchType = _matchType;
    }

    @NotNull
    public static NBTIngredient fromStack(@NotNull ItemStack _stack, @NotNull MatchType _matchType) {
        return new NBTIngredient(_stack, _matchType);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || this.stack.m_41720_() != input.m_41720_() || this.stack.m_41773_() != input.m_41773_()) {
            return false;
        }
        return switch (this.matchType) {
            default -> throw new IncompatibleClassChangeError();
            case MatchType.EQUAL -> this.stack.areShareTagsEqual(input);
            case MatchType.CONTAINS -> this.containsNBT((Tag)this.stack.m_41783_(), (Tag)input.m_41783_());
            case MatchType.CONTAINS_NONE -> this.containsNoneNBT((Tag)this.stack.m_41783_(), (Tag)input.m_41783_());
            case MatchType.NOT_EQUAL -> !this.stack.areShareTagsEqual(input);
        };
    }

    private boolean containsNBT(@Nullable Tag nbt1, @Nullable Tag nbt2) {
        if (nbt1 == nbt2) {
            return true;
        }
        if (nbt1 == null) {
            return true;
        }
        if (nbt2 == null) {
            return false;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            if (nbt1 instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt1;
                CompoundTag compoundTag1 = (CompoundTag)nbt2;
                for (String key : compoundTag.m_128431_()) {
                    Tag inbt1 = compoundTag.m_128423_(key);
                    if (this.containsNBT(inbt1, compoundTag1.m_128423_(key))) continue;
                    return false;
                }
                return true;
            }
            if (nbt1 instanceof ListTag) {
                ListTag listTag = (ListTag)nbt1;
                ListTag listTag1 = (ListTag)nbt2;
                if (listTag.isEmpty()) {
                    return listTag1.isEmpty();
                }
                for (Tag inbt : listTag) {
                    boolean containsNone = true;
                    for (Tag value : listTag1) {
                        if (!this.containsNBT(inbt, value)) continue;
                        containsNone = false;
                        break;
                    }
                    if (!containsNone) continue;
                    return false;
                }
                return true;
            }
            return nbt1.equals(nbt2);
        }
        return false;
    }

    private boolean containsNoneNBT(@Nullable Tag nbt1, @Nullable Tag nbt2) {
        if (nbt1 == nbt2) {
            return false;
        }
        if (nbt1 == null) {
            return false;
        }
        if (nbt2 == null) {
            return true;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            if (nbt1 instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt1;
                CompoundTag compoundTag1 = (CompoundTag)nbt2;
                for (String key : compoundTag.m_128431_()) {
                    Tag inbt1 = compoundTag.m_128423_(key);
                    if (this.containsNoneNBT(inbt1, compoundTag1.m_128423_(key))) continue;
                    return false;
                }
                return true;
            }
            if (nbt1 instanceof ListTag) {
                ListTag listTag = (ListTag)nbt1;
                ListTag listTag1 = (ListTag)nbt2;
                if (listTag.isEmpty()) {
                    return false;
                }
                for (Tag inbt : listTag) {
                    boolean contains = false;
                    for (Tag value : listTag1) {
                        if (this.containsNoneNBT(inbt, value)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    return false;
                }
                return true;
            }
            return !nbt1.equals(nbt2);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        return ModIngredientSerializersRegisterFactory.NBT_INGREDIENT;
    }

    @NotNull
    ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    MatchType getMatchType() {
        return this.matchType;
    }
}

