/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.minecraft_forge_api.elements.recipes.EnumCodec;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.NBTIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class NBTIngredientSerializer
implements IIngredientSerializer<NBTIngredient> {
    private static final Codec<NBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.f_41582_.fieldOf("stack").forGetter(NBTIngredient::getStack), (App)new EnumCodec(MatchType.class).fieldOf("matchType").forGetter(NBTIngredient::getMatchType)).apply((Applicative)builder, NBTIngredient::new));

    public Codec<? extends NBTIngredient> codec() {
        return CODEC;
    }

    public void write(@NotNull FriendlyByteBuf buffer, @NotNull NBTIngredient ingredient) {
        buffer.m_130055_(ingredient.getStack());
        buffer.writeInt(ingredient.getMatchType().ordinal());
    }

    @NotNull
    public NBTIngredient read(FriendlyByteBuf buffer) {
        return NBTIngredient.fromStack(buffer.m_130267_(), MatchType.values()[buffer.readInt()]);
    }
}

