/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeResult;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NBTRecipeSerializer<R extends NBTRecipe>
implements RecipeSerializer<R> {
    private static final Codec<Item> ITEM_NONAIR_CODEC = ExtraCodecs.m_264370_((Codec)BuiltInRegistries.f_257033_.m_194605_(), builder -> builder == Items.f_41852_ ? DataResult.error(() -> "Crafting result must not be minecraft:air") : DataResult.success((Object)builder));
    protected static final Codec<NBTRecipeResult> RESULT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_NONAIR_CODEC.fieldOf("item").forGetter(NBTRecipeResult::item), (App)TagParser.f_290338_.fieldOf("nbt").forGetter(NBTRecipeResult::nbt), (App)ExtraCodecs.m_295827_((Codec)ExtraCodecs.f_144629_, (String)"count", (Object)1).forGetter(NBTRecipeResult::count), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"merge_nbt", (Object)true).forGetter(NBTRecipeResult::mergeNbt)).apply((Applicative)builder, NBTRecipeResult::new));

    @Nullable
    public R fromNetwork(@NotNull FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        ItemStack result = buffer.m_130267_();
        boolean merge_nbt = buffer.readBoolean();
        return this.buildRecipe(buffer, group, result, merge_nbt);
    }

    @NotNull
    protected abstract R buildRecipe(@NotNull FriendlyByteBuf var1, @NotNull String var2, @NotNull ItemStack var3, boolean var4);

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull R recipe) {
        buffer.m_130070_(((NBTRecipe)recipe).m_6076_());
        buffer.m_130055_(((NBTRecipe)recipe).getResult());
        buffer.writeBoolean(((NBTRecipe)recipe).isMergeNbt());
        this.writeRecipeData(buffer, recipe);
    }

    protected abstract void writeRecipeData(@NotNull FriendlyByteBuf var1, @NotNull R var2);
}

