/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeSerializer;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt.ShapelessNBTRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ShapelessNBTRecipeSerializer
extends NBTRecipeSerializer<ShapelessNBTRecipe> {
    private static final Codec<ShapelessNBTRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(NBTRecipe::m_6076_), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(recipe -> {
        Object[] ingredients = (Ingredient[])recipe.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
        if (ingredients.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }, DataResult::success).forGetter(NBTRecipe::m_7527_), (App)RESULT_CODEC.fieldOf("result").forGetter(NBTRecipe::getNBTRecipeResult)).apply((Applicative)builder, ShapelessNBTRecipe::new));

    @NotNull
    public Codec<ShapelessNBTRecipe> m_292673_() {
        return CODEC;
    }

    @Override
    @NotNull
    protected ShapelessNBTRecipe buildRecipe(@NotNull FriendlyByteBuf buffer, @NotNull String group, @NotNull ItemStack result, boolean merge_nbt) {
        int ingredientCount = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return new ShapelessNBTRecipe(group, (NonNullList<Ingredient>)ingredients, result, merge_nbt);
    }

    @Override
    protected void writeRecipeData(@NotNull FriendlyByteBuf buffer, @NotNull ShapelessNBTRecipe recipe) {
        buffer.m_130130_(recipe.m_7527_().size());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
    }
}

