/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BackpackDyeRecipe
extends CustomRecipe {
    public BackpackDyeRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack itemstack = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack1 = container.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            if (itemstack1.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
                if (!itemstack.m_41619_()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (!(itemstack1.m_41720_() instanceof DyeItem)) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.m_41619_() && !list.isEmpty();
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ArrayList list = Lists.newArrayList();
        ItemStack stack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack ingredient = container.m_8020_(i);
            if (ingredient.m_41619_()) continue;
            if (ingredient.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
                stack = container.m_8020_(i).m_41777_();
                continue;
            }
            if (!(ingredient.m_41720_() instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            list.add((DyeItem)ingredient.m_41720_());
        }
        return !stack.m_41619_() && !list.isEmpty() ? BackpackDyeRecipe.dyeItem(stack, list) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_DYE.get();
    }

    public static boolean hasColor(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128441_("Color");
        }
        return false;
    }

    public static int getColor(ItemStack stack) {
        return stack.m_41783_().m_128451_("Color");
    }

    public static void setColor(ItemStack stack, int color) {
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128405_("Color", color);
        } else {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("Color", color);
            stack.m_41751_(compoundTag);
        }
    }

    public static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyeItem) {
        if (stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            int lvt_13_1_;
            float b;
            int[] ints = new int[3];
            int lvt_4_1_ = 0;
            int lvt_5_1_ = 0;
            if (BackpackDyeRecipe.hasColor(stack)) {
                int baseColor = BackpackDyeRecipe.getColor(stack);
                float r = (float)(baseColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(baseColor >> 8 & 0xFF) / 255.0f;
                b = (float)(baseColor & 0xFF) / 255.0f;
                lvt_4_1_ = (int)((float)lvt_4_1_ + Math.max(r, Math.max(g, b)) * 255.0f);
                ints[0] = (int)((float)ints[0] + r * 255.0f);
                ints[1] = (int)((float)ints[1] + g * 255.0f);
                ints[2] = (int)((float)ints[2] + b * 255.0f);
                ++lvt_5_1_;
            }
            for (DyeItem lvt_9_2_ : dyeItem) {
                float[] lvt_10_2_ = lvt_9_2_.m_41089_().m_41068_();
                int lvt_11_2_ = (int)(lvt_10_2_[0] * 255.0f);
                int lvt_12_1_ = (int)(lvt_10_2_[1] * 255.0f);
                lvt_13_1_ = (int)(lvt_10_2_[2] * 255.0f);
                lvt_4_1_ += Math.max(lvt_11_2_, Math.max(lvt_12_1_, lvt_13_1_));
                ints[0] = ints[0] + lvt_11_2_;
                ints[1] = ints[1] + lvt_12_1_;
                ints[2] = ints[2] + lvt_13_1_;
                ++lvt_5_1_;
            }
            int lvt_8_2_ = ints[0] / lvt_5_1_;
            int lvt_9_3_ = ints[1] / lvt_5_1_;
            int lvt_10_3_ = ints[2] / lvt_5_1_;
            b = (float)lvt_4_1_ / (float)lvt_5_1_;
            float lvt_12_2_ = Math.max(lvt_8_2_, Math.max(lvt_9_3_, lvt_10_3_));
            lvt_8_2_ = (int)((float)lvt_8_2_ * b / lvt_12_2_);
            lvt_9_3_ = (int)((float)lvt_9_3_ * b / lvt_12_2_);
            lvt_10_3_ = (int)((float)lvt_10_3_ * b / lvt_12_2_);
            lvt_13_1_ = (lvt_8_2_ << 8) + lvt_9_3_;
            lvt_13_1_ = (lvt_13_1_ << 8) + lvt_10_3_;
            BackpackDyeRecipe.setColor(stack, lvt_13_1_);
        }
        return stack;
    }
}

