/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ServerboundEquipBackpackPacket {
    private final boolean equip;

    public ServerboundEquipBackpackPacket(boolean equip) {
        this.equip = equip;
    }

    public static ServerboundEquipBackpackPacket decode(FriendlyByteBuf buffer) {
        boolean equip = buffer.readBoolean();
        return new ServerboundEquipBackpackPacket(equip);
    }

    public static void encode(ServerboundEquipBackpackPacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.equip);
    }

    public static void handle(ServerboundEquipBackpackPacket message, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            if (serverPlayer != null) {
                if (message.equip) {
                    if (!TravelersBackpack.enableCurios()) {
                        if (!CapabilityUtils.isWearingBackpack((Player)serverPlayer)) {
                            ServerActions.equipBackpack((Player)serverPlayer);
                        } else {
                            serverPlayer.m_6915_();
                            serverPlayer.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.equip_otherbackpack"));
                        }
                    }
                } else if (!TravelersBackpack.enableCurios()) {
                    if (CapabilityUtils.isWearingBackpack((Player)serverPlayer)) {
                        ServerActions.unequipBackpack((Player)serverPlayer);
                    } else {
                        serverPlayer.m_6915_();
                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.unequip_nobackpack"));
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

