/*
 * Decompiled with CFR 0.152.
 */
package com.wardenhorn;

import com.wardenhorn.DamageSources;
import com.wardenhorn.SonicConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonicBoomAPI {
    public static void createBoom(ServerLevel level, Player shooter) {
        int rangeMax = (Integer)SonicConfig.range.get();
        float boomDamage = ((Double)SonicConfig.damage.get()).floatValue();
        double knockbackMultiplier = (Double)SonicConfig.knockback.get();
        boolean shouldBlocksStop = (Boolean)SonicConfig.stopAtBlocks.get();
        Vec3 shooterHeadPosition = shooter.m_146892_();
        for (int i = 0; i < rangeMax; ++i) {
            Vec3 particleSpawnSpot = shooterHeadPosition.m_82520_(shooter.m_20156_().f_82479_ * (double)i, shooter.m_20156_().f_82480_ * (double)i, shooter.m_20156_().f_82481_ * (double)i);
            BlockPos hitBlockPos = new BlockPos((int)particleSpawnSpot.f_82479_, (int)particleSpawnSpot.f_82480_, (int)particleSpawnSpot.f_82481_);
            BlockState hitBlockState = level.m_8055_(hitBlockPos);
            if (!shouldBlocksStop || hitBlockState.m_60795_() || !hitBlockState.m_60815_()) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particleSpawnSpot.f_82479_, particleSpawnSpot.f_82480_, particleSpawnSpot.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                AABB aABB = new AABB(hitBlockPos).m_82377_(0.8, 0.8, 0.8);
                List livingEntityList = level.m_45976_(LivingEntity.class, aABB);
                for (LivingEntity livingEntity : livingEntityList) {
                    if (livingEntity.m_7306_((Entity)shooter)) continue;
                    livingEntity.m_6469_(DamageSources.hornedShriek((LivingEntity)shooter, (Level)level), boomDamage);
                    double verticalResistance = 0.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    double horizontalResistance = 2.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    livingEntity.m_5997_(shooter.m_20156_().f_82479_ * knockbackMultiplier * horizontalResistance, shooter.m_20156_().f_82480_ * knockbackMultiplier * verticalResistance, shooter.m_20156_().f_82481_ * knockbackMultiplier * horizontalResistance);
                }
                continue;
            }
            i = rangeMax + 1;
        }
        shooter.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
    }
}

