/*
 * Decompiled with CFR 0.152.
 */
package com.wither.withersweapons.common.items;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class DiablowItem
extends BowItem {
    public DiablowItem(Item.Properties properties) {
        super(properties);
    }

    protected boolean isAmmoRequired(ItemStack bow, Player shooter) {
        return !shooter.m_150110_().f_35937_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bow) == 0;
    }

    protected InteractionResultHolder<ItemStack> nockArrow(ItemStack bow, Level world, Player shooter, InteractionHand hand) {
        boolean hasAmmo = !shooter.m_6298_(bow).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)bow, (Level)world, (Player)shooter, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (this.isAmmoRequired(bow, shooter) && !hasAmmo) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)bow);
        }
        shooter.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)bow);
    }

    void fireArrow(ItemStack bow, Level level, LivingEntity shooter, int charge) {
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        boolean ammoRequired = this.isAmmoRequired(bow, player);
        ItemStack ammo = player.m_6298_(bow);
        charge = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)level, (Player)player, (int)charge, (!ammo.m_41619_() || !ammoRequired ? 1 : 0) != 0);
        if (charge < 0) {
            return;
        }
        if (!ammo.m_41619_() || !ammoRequired) {
            float arrowVelocity;
            if (ammo.m_41619_()) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
            }
            if ((double)(arrowVelocity = DiablowItem.m_40661_(charge)) >= 0.1) {
                boolean isInfinite;
                boolean bl = isInfinite = player.m_150110_().f_35937_ || ammo.m_41720_() instanceof ArrowItem && ((ArrowItem)ammo.m_41720_()).isInfinite(ammo, bow, player);
                if (!level.f_46443_) {
                    int punchLevel;
                    int powerLevel;
                    ArrowItem arrowItem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
                    AbstractArrow arrowEntity = arrowItem.m_6394_(level, ammo, (LivingEntity)player);
                    arrowEntity = this.customArrow(arrowEntity);
                    arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, arrowVelocity * 3.0f, 1.0f);
                    arrowEntity.m_20254_(100);
                    arrowEntity.m_36767_((byte)2);
                    if (arrowVelocity == 1.0f) {
                        arrowEntity.m_36762_(true);
                    }
                    if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bow)) > 0) {
                        arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
                    }
                    if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bow)) > 0) {
                        arrowEntity.m_36735_(punchLevel);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bow) > 0) {
                        arrowEntity.m_20254_(100);
                    }
                    bow.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
                    if (isInfinite) {
                        arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)arrowEntity);
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                if (!isInfinite && !player.m_150110_().f_35937_) {
                    ammo.m_41774_(1);
                    if (ammo.m_41619_()) {
                        player.m_150109_().m_36057_(ammo);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public int m_8105_(ItemStack p_40680_) {
        return 72000;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        int charge = stack.m_41779_() * 15;
        this.fireArrow(stack, level, livingEntity, charge);
        return stack;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        int charge = stack.m_41779_() - timeLeft;
        this.fireArrow(stack, level, livingEntity, charge);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand hand) {
        return this.nockArrow(playerIn.m_21120_(hand), level, playerIn, hand);
    }

    public static float m_40661_(int p_40662_) {
        float f = (float)p_40662_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.3f;
        }
        return f;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == Items.f_42585_;
    }
}

