/*
 * Decompiled with CFR 0.152.
 */
package com.wither.withersweapons.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemLootModifier
extends LootModifier {
    public static final Supplier<Codec<ItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("name").forGetter(m -> m.item)).and((App)LootItemFunctions.f_291699_.listOf().fieldOf("functions").forGetter(m -> m.functions)).apply((Applicative)inst, ItemLootModifier::new)));
    private final Item item;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;

    public ItemLootModifier(LootItemCondition[] conditions, Item item, List<LootItemFunction> functions) {
        super(conditions);
        this.item = item;
        this.functions = functions;
        this.compositeFunction = LootItemFunctions.m_80770_(functions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        this.compositeFunction.apply(stack, context);
        generatedLoot.add((Object)stack);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

