/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MyTinyButton;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.KeySortableByOther;
import xaero.map.misc.Misc;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

public abstract class GuiSettings
extends ScreenBase {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected Component screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    private EditBox searchField;
    protected boolean canSearch = true;
    protected boolean shouldAddBackButton = true;
    private boolean shouldRefocusSearch;

    public GuiSettings(Component title, Screen backScreen, Screen escScreen) {
        super(backScreen, escScreen, title);
    }

    @Override
    public void m_7856_() {
        int verticalOffset;
        super.m_7856_();
        this.screenTitle = this.f_96539_;
        if (this.shouldAddBackButton) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237110_((String)"gui.xaero_back", (Object[])new Object[0]), b -> this.goBack()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 200, 20).m_253136_());
        }
        int n = verticalOffset = this.canSearch ? 24 : 0;
        if (this.entries != null) {
            boolean canEditIngameSettings = ModSettings.canEditIngameSettings();
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    AbstractWidget optionWidget = entry.createWidget(this.f_96543_ / 2 - 205 + i % 2 * 210, this.f_96544_ / 7 + verticalOffset + 24 * (i >> 1), 200, canEditIngameSettings);
                    this.m_142416_((GuiEventListener)optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.m_6879_().m_130946_(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.f_96543_ / 2 + 131, this.f_96544_ / 7 + 144 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_wm_next", (Object[])new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.f_96543_ / 2 - 205, this.f_96544_ / 7 + 144 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_wm_previous", (Object[])new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.m_142416_((GuiEventListener)this.nextButton);
            this.m_142416_((GuiEventListener)this.prevButton);
            this.nextButton.f_93623_ = this.page < this.maxPage;
            boolean bl = this.prevButton.f_93623_ = this.page > 0;
        }
        if (this.canSearch) {
            boolean shouldFocusSearch = this.shouldRefocusSearch;
            this.shouldRefocusSearch = false;
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.m_94207_();
            }
            this.searchField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_wm_settings_search"));
            this.searchField.m_94144_(this.entryFilter);
            if (shouldFocusSearch) {
                this.m_7522_((GuiEventListener)this.searchField);
                this.searchField.m_94196_(cursorPos);
                this.searchField.m_94208_(cursorPos);
            }
            this.searchField.m_94151_(s -> {
                if (this.canSearch) {
                    this.updateSearch();
                }
            });
            this.m_7787_(this.searchField);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.canSearch) {
            // empty if block
        }
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_280273_(guiGraphics, i, j, f);
        guiGraphics.m_280653_(this.f_96541_.f_91062_, this.screenTitle, this.f_96543_ / 2, 5, 0xFFFFFF);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        super.m_88315_(guiGraphics, par1, par2, par3);
        if (this.canSearch) {
            if (!this.foundSomething) {
                guiGraphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.xaero_wm_settings_not_found", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 7 + 29, 0xFFFFFF);
            }
            if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
                Misc.setFieldText(this.searchField, I18n.m_118938_((String)"gui.xaero_wm_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.m_94192_(0, false);
            }
            this.searchField.m_88315_(guiGraphics, par1, par2, par3);
            if (!this.searchField.m_93696_()) {
                Misc.setFieldText(this.searchField, this.entryFilter);
            }
        }
        this.renderTooltips(guiGraphics, par1, par2, par3);
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                GuiEventListener child = (GuiEventListener)this.m_6702_().get(index);
                this.m_7522_(child);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(GuiEventListener child) {
        for (int i = 0; i < this.m_6702_().size(); ++i) {
            if (this.m_6702_().get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        super.onExit(screen);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (!(super.m_7933_(par1, par2, par3) || this.m_7222_() instanceof EditBox && ((EditBox)this.m_7222_()).m_93696_())) {
            if (Misc.inputMatchesKeyBinding(par1 != -1 ? InputConstants.Type.KEYSYM : InputConstants.Type.SCANCODE, par1 != -1 ? par1 : par2, ControlsRegister.keyOpenSettings, (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.m_7379_();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean m_5534_(char c, int i) {
        boolean result = super.m_5534_(c, i);
        return result;
    }

    @Override
    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (!super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            if (Misc.inputMatchesKeyBinding(InputConstants.Type.MOUSE, p_mouseClicked_5_, ControlsRegister.keyOpenSettings, (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    protected void onNextButton() {
        ++this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected void onPrevButton() {
        --this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected static ISettingEntry[] entriesFromOptions(ModOptions[] options) {
        ISettingEntry[] result = new ISettingEntry[options.length];
        for (int i = 0; i < options.length; ++i) {
            result[i] = new ConfigSettingEntry(options[i]);
        }
        return result;
    }

    protected void resetConfirmResult(boolean result, Screen parent, Screen escScreen) {
        if (result) {
            WorldMapSession minimapSession = WorldMapSession.getCurrentSession();
            if (minimapSession != null) {
                // empty if block
            }
            try {
                WorldMap.settings = new ModSettings();
                WorldMap.settings.saveSettings();
            }
            catch (IOException e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            WorldMap.settings.updateRegionCacheHashCode();
        }
        Minecraft.m_91087_().m_91152_(parent);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.m_93696_() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.m_94155_()))) {
            this.entryFilter = this.searchField.m_94155_();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }
}

