/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class PacketConsumerForge<T extends WorldMapMessage<T>>
implements BiConsumer<T, CustomPayloadEvent.Context> {
    private final ServerMessageConsumer<T> serverHandler;
    private final ClientMessageConsumer<T> clientHandler;

    public PacketConsumerForge(ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(T msg, CustomPayloadEvent.Context context) {
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        NetworkDirection networkDirection = context.getDirection();
        if (this.clientHandler != null && networkDirection == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> this.clientHandler.handle((WorldMapMessage)msg));
        } else if (this.serverHandler != null && networkDirection == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.handle(sender.m_20194_(), sender, (WorldMapMessage)msg));
        }
        context.setPacketHandled(true);
    }
}

