/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import xaero.map.WorldMap;
import xaero.map.message.PacketConsumerForge;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class WorldMapMessageHandler {
    public static final int NETWORK_COMPATIBILITY = 2;

    public <T extends WorldMapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, FriendlyByteBuf> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            WorldMap.network.messageBuilder(type, index, clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
            return;
        }
        WorldMap.network.messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
    }

    public void sendToPlayer(ServerPlayer player, WorldMapMessage<?> message) {
        WorldMap.network.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public void sendToServer(WorldMapMessage<?> message) {
        WorldMap.network.send(message, PacketDistributor.SERVER.noArg());
    }
}

